/*
 * Decompiled with CFR 0.152.
 */
package org.spin.appwrite120.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONObject;
import org.spin.appwrite120.utils.AppWrite;
import org.spin.appwrite120.utils.IAppWriteData;
import org.spin.queue.store.event.ECommerceEventListener;
import org.spin.queue.store.support.IECommerce;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.queue.store.util.FindCriteria;

public class Index
implements IAppWriteData {
    AppWrite api = null;
    private static final String INDEX_KEY = "key";
    private static final String INDEX_TYPE = "type";
    public static final String INDEX_TYPE_KEY = "key";
    public static final String INDEX_TYPE_UNIQUE = "unique";
    public static final String INDEX_TYPE_FULLTEXT = "fulltext";
    private static final String INDEX_STATUS = "type";
    private static final String INDEX_ATTRIBUTES = "attributes";
    private static final String INDEX_ORDERS = "orders";
    public static final String INDEX_ORDERS_ASC = "ASC";
    public static final String INDEX_ORDERS_DESC = "DESC";
    private Map<String, Object> indexValues = new HashMap<String, Object>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("databaseId", "");
            this.put("collectionId", "");
            this.put("type", Index.INDEX_TYPE_FULLTEXT);
            this.put("key", "");
            this.put(Index.INDEX_ATTRIBUTES, new JSONArray());
            this.put(Index.INDEX_ORDERS, new JSONArray());
        }
    };

    public Map<String, Object> createKey() {
        return this.create(this.getKey(), "key");
    }

    public Map<String, Object> createUnique() {
        return this.create(this.getKey(), INDEX_TYPE_UNIQUE);
    }

    public Map<String, Object> createFullText() {
        return this.create(this.getKey(), INDEX_TYPE_FULLTEXT);
    }

    @Override
    public Map<String, Object> parseOutputData(JSONObject data) {
        Optional<JSONObject> maybeResponseData = Optional.ofNullable(data);
        HashMap<String, Object> parsedData = new HashMap<String, Object>();
        maybeResponseData.ifPresent(responseData -> {
            if (responseData.toMap().get("error") == null) {
                if (this.api.getAction().equals("L")) {
                    Optional<JSONArray> maybeIndexes = Optional.ofNullable(responseData.getJSONArray("indexes"));
                    maybeIndexes.ifPresent(IndexesObj -> IndexesObj.forEach(IndexObj -> {
                        JSONObject attribute = (JSONObject)IndexObj;
                        parsedData.put(attribute.getString("key"), this.parseDataFromJson(attribute));
                    }));
                } else if (this.api.getAction().equals("C")) {
                    JSONObject index = responseData;
                    parsedData.put(index.getString("key"), this.parseDataFromJson(index));
                }
            }
        });
        this.api.clearPaths();
        return parsedData;
    }

    private HashMap<String, Object> parseDataFromJson(JSONObject data) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("key", data.getString("key"));
        item.put("type", data.getString("type"));
        item.put("type", data.getString("type"));
        item.put(INDEX_ATTRIBUTES, data.getJSONArray(INDEX_ATTRIBUTES));
        item.put(INDEX_ORDERS, data.getJSONArray(INDEX_ORDERS));
        return item;
    }

    public Map<String, Object> createAttribute() {
        return this.create(this.getType());
    }

    public Map<String, Object> create(String indexType) {
        this.api.withPath("databases");
        this.api.withPath(this.getDatabaseId());
        this.api.withPath("collections");
        this.api.withPath(this.getCollectionId());
        this.api.withPath("indexes");
        this.api.withRequestType("POST");
        this.api.withDataToSend("databaseId", this.getDatabaseId());
        this.api.withDataToSend("collectionId", this.getCollectionId());
        this.api.withDataToSend("key", this.getKey());
        this.api.withDataToSend("type", indexType);
        this.api.withDataToSend(INDEX_ATTRIBUTES, this.getAttributes());
        this.api.withDataToSend(INDEX_ORDERS, this.getOrders());
        JSONObject data = this.api.getOutputData();
        this.api.setAction("C");
        return this.parseOutputData(data);
    }

    public Map<String, Object> create(String indexKey, String indexType) {
        this.setKey(indexKey);
        AtomicReference<Object> responseParsed = new AtomicReference<Object>(null);
        this.list().entrySet().stream().filter(val -> ((Map)Optional.ofNullable((Map)val.getValue()).orElse(new HashMap())).get("name").toString().equals(indexKey)).forEach(collectionMap -> {
            HashMap result = new HashMap();
            this.setId((String)collectionMap.getKey());
            result.put(collectionMap.getKey(), collectionMap.getValue());
            responseParsed.set(result);
        });
        return Optional.ofNullable(responseParsed.get()).orElseGet(() -> this.create(indexType));
    }

    public Map<String, Object> listIndex() {
        this.api.withPath("databases");
        this.api.withPath(this.getDatabaseId());
        this.api.withPath("collections");
        this.api.withPath(this.getCollectionId());
        this.api.withPath("indexes");
        this.api.withRequestType("GET");
        JSONObject data = this.api.getOutputData();
        this.api.setAction("L");
        return this.parseOutputData(data);
    }

    public Map<String, Object> getIndex() {
        this.api.withPath("databases");
        this.api.withPath(this.getDatabaseId());
        this.api.withPath("collections");
        this.api.withPath(this.getCollectionId());
        this.api.withPath("indexes");
        this.api.withPath(this.getKey());
        this.api.withRequestType("GET");
        JSONObject data = this.api.getOutputData();
        this.api.setAction("G");
        return this.parseOutputData(data);
    }

    public Map<String, Object> deleteIndex() {
        this.api.withPath("databases");
        this.api.withPath(this.getDatabaseId());
        this.api.withPath("collections");
        this.api.withPath(this.getCollectionId());
        this.api.withPath("indexes");
        this.api.withPath(this.getKey());
        this.api.withRequestType("DELETE");
        JSONObject data = this.api.getOutputData();
        this.api.setAction("D");
        return this.parseOutputData(data);
    }

    public int getIntValue(String key) {
        return Integer.valueOf(Optional.ofNullable(String.valueOf(this.indexValues.get(key))).orElse("0"));
    }

    public String getStringValue(String key) {
        return String.valueOf(Optional.ofNullable(String.valueOf(this.indexValues.get(key))).orElse(""));
    }

    public boolean getBooleanValue(String key) {
        return Optional.ofNullable((Boolean)this.indexValues.get(key)).orElse(false);
    }

    public String getId() {
        return this.getStringValue("key");
    }

    public void setId(String id) {
        this.setValue("key", id);
    }

    public AppWrite getApi() {
        return this.api;
    }

    public void setApi(AppWrite api) {
        this.api = api;
    }

    public String getDatabaseId() {
        return this.getStringValue("databaseId");
    }

    public void setDatabaseId(String databaseId) {
        this.setValue("databaseId", databaseId);
    }

    public String getCollectionId() {
        return this.getStringValue("collectionId");
    }

    public void setCollectionId(String collectionId) {
        this.setValue("collectionId", collectionId);
    }

    public String getKey() {
        return this.getStringValue("key");
    }

    public void setKey(String key) {
        this.setValue("key", key);
    }

    public JSONArray getAttributes() {
        return Optional.ofNullable((JSONArray)this.getValue(INDEX_ATTRIBUTES)).orElse(new JSONArray());
    }

    public void setAttributes(JSONArray elements) {
        this.setValue(INDEX_ATTRIBUTES, elements);
    }

    public JSONArray getOrders() {
        return Optional.ofNullable((JSONArray)this.getValue(INDEX_ORDERS)).orElse(new JSONArray());
    }

    public void setOrders(JSONArray elements) {
        this.setValue(INDEX_ORDERS, elements);
    }

    public void setType(String type) {
        this.setValue("type", type);
    }

    public String getType() {
        return this.getStringValue("type");
    }

    public String getIdentifier() {
        return this.getStringValue("key");
    }

    public Object getValue(String key) {
        return this.indexValues.get(key);
    }

    public boolean isValid() {
        return false;
    }

    public void setValue(String key, Object value) {
        this.indexValues.put(key, value);
    }

    public Map<String, Object> getAllValues() {
        return this.indexValues;
    }

    public IECommerceEntity withApi(IECommerce api) {
        return this;
    }

    public IECommerceEntity withListener(ECommerceEventListener listener) {
        return this;
    }

    public IECommerceEntity create() {
        this.createAttribute().entrySet().forEach(index -> this.setValue((String)index.getKey(), index.getValue()));
        this.api.setInputData(new JSONObject());
        return this;
    }

    public IECommerceEntity update() {
        return this;
    }

    public IECommerceEntity delete() {
        this.deleteIndex();
        return this;
    }

    public IECommerceEntity find(FindCriteria criteria) {
        return null;
    }

    public IECommerceEntity withWebStoreId(int webStoreId) {
        return null;
    }

    @Override
    public IAppWriteData withAppWriteApi(AppWrite api) {
        this.api = api;
        return this;
    }

    public String toString() {
        return this.indexValues.toString();
    }

    @Override
    public Map<String, Object> list() {
        return this.listIndex();
    }

    @Override
    public Map<String, Object> get(String key) {
        this.setId(key);
        return this.getIndex();
    }
}

