/*
 * Decompiled with CFR 0.152.
 */
package org.spin.appwrite120.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONObject;
import org.spin.appwrite120.utils.AppWrite;
import org.spin.appwrite120.utils.AppWriteUtils;
import org.spin.appwrite120.utils.IAppWriteData;
import org.spin.queue.store.event.ECommerceEventListener;
import org.spin.queue.store.support.IECommerce;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.queue.store.util.FindCriteria;

public class Collection
implements IAppWriteData {
    AppWrite api = null;
    private Map<String, Object> collectionValues = new HashMap<String, Object>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("$id", "");
            this.put("collectionId", "unique()");
            this.put("name", "");
            this.put("databaseId", "");
            this.put("permissions", AppWriteUtils.PERMISSION_EMPTY);
            this.put("documentSecurity", false);
        }
    };

    public Collection withAPI(AppWrite api) {
        this.api = api;
        return this;
    }

    @Override
    public Map<String, Object> parseOutputData(JSONObject data) {
        Optional<JSONObject> maybeResponseData = Optional.ofNullable(data);
        HashMap<String, Object> parsedData = new HashMap<String, Object>();
        maybeResponseData.ifPresent(responseData -> {
            if (responseData.toMap().get("error") == null) {
                if (this.api.getAction().equals("L")) {
                    Optional<JSONArray> maybeCollections = Optional.ofNullable(responseData.getJSONArray("collections"));
                    maybeCollections.ifPresent(collectionsObj -> collectionsObj.forEach(collectionObj -> {
                        JSONObject collection = (JSONObject)collectionObj;
                        HashMap<String, Object> item = new HashMap<String, Object>();
                        item.put("name", collection.getString("name"));
                        item.put("$createdAt", collection.getString("$createdAt"));
                        item.put("$permissions", collection.getJSONArray("$permissions"));
                        item.put("attributes", collection.getJSONArray("attributes"));
                        item.put("databaseId", collection.getString("databaseId"));
                        item.put("enabled", collection.getBoolean("enabled"));
                        item.put("$id", collection.getString("$id"));
                        item.put("$updatedAt", collection.getString("$updatedAt"));
                        parsedData.put(collection.getString("$id"), item);
                    }));
                } else if (this.api.getAction().equals("C")) {
                    JSONObject collection = responseData;
                    HashMap<String, Object> item = new HashMap<String, Object>();
                    item.put("name", collection.getString("name"));
                    item.put("$createdAt", collection.getString("$createdAt"));
                    item.put("$permissions", collection.getJSONArray("$permissions"));
                    item.put("attributes", collection.getJSONArray("attributes"));
                    item.put("databaseId", collection.getString("databaseId"));
                    item.put("enabled", collection.getBoolean("enabled"));
                    item.put("$id", collection.getString("$id"));
                    item.put("$updatedAt", collection.getString("$updatedAt"));
                    parsedData.put(collection.getString("$id"), item);
                } else if (this.api.getAction().equals("D")) {
                    JSONObject collection = responseData;
                    HashMap<String, String> item = new HashMap<String, String>();
                    item.put("response", collection.getString("response"));
                    parsedData.put("response", item);
                }
            }
        });
        this.api.clearPaths();
        return parsedData;
    }

    private Map<String, Object> createCollection() {
        this.api.withPath("databases");
        this.api.withPath(this.getDatabaseId());
        this.api.withPath("collections");
        this.api.withRequestType("POST");
        this.api.withDataToSend("databaseId", this.getDatabaseId());
        this.api.withDataToSend("collectionId", this.getId());
        this.api.withDataToSend("name", this.getName());
        this.api.withDataToSend("permissions", this.getPermision());
        this.api.withDataToSend("documentSecurity", this.getDocumentSecuriry());
        JSONObject data = this.api.getOutputData();
        this.api.setAction("C");
        return this.parseOutputData(data);
    }

    public Map<String, Object> createCollectionIfNotExists() {
        return this.createCollection(this.getName());
    }

    public Map<String, Object> createCollection(String collectionName) {
        this.setName(collectionName);
        AtomicReference<Object> responseParsed = new AtomicReference<Object>(null);
        this.list().entrySet().stream().filter(val -> ((Map)Optional.ofNullable((Map)val.getValue()).orElse(new HashMap())).get("name").toString().equals(collectionName)).forEach(collectionMap -> {
            HashMap result = new HashMap();
            this.setId((String)collectionMap.getKey());
            result.put(collectionMap.getKey(), collectionMap.getValue());
            responseParsed.set(result);
        });
        return Optional.ofNullable(responseParsed.get()).orElseGet(() -> this.createCollection());
    }

    public Map<String, Object> listCollections() {
        this.api.withPath("databases");
        this.api.withPath(this.getDatabaseId());
        this.api.withPath("collections");
        this.api.withRequestType("GET");
        JSONObject data = this.api.getOutputData();
        this.api.setAction("L");
        return this.parseOutputData(data);
    }

    public Map<String, Object> getCollection(String collectionId) {
        this.api.withPath("databases");
        this.api.withPath(this.getDatabaseId());
        this.api.withPath("collections");
        this.api.withPath(collectionId);
        this.api.withRequestType("GET");
        JSONObject data = this.api.getOutputData();
        this.api.setAction("G");
        return this.parseOutputData(data);
    }

    public Map<String, Object> updateCollection() {
        this.api.withPath("databases");
        this.api.withPath(this.getDatabaseId());
        this.api.withPath("collections");
        this.api.withPath(this.getId());
        this.api.withRequestType("PUT");
        this.api.withDataToSend("name", this.getName());
        this.api.withDataToSend("documentSecurity", this.getDocumentSecuriry());
        JSONObject data = this.api.getOutputData();
        this.api.setAction("U");
        return this.parseOutputData(data);
    }

    public Map<String, Object> deleteCollection() {
        this.api.withPath("databases");
        this.api.withPath(this.getDatabaseId());
        this.api.withPath("collections");
        this.api.withPath(this.getId());
        this.api.withRequestType("DELETE");
        JSONObject data = this.api.getOutputData();
        this.api.setAction("D");
        return this.parseOutputData(data);
    }

    public int getIntValue(String key) {
        return Integer.valueOf(Optional.ofNullable(String.valueOf(this.collectionValues.get(key))).orElse("0"));
    }

    public String getStringValue(String key) {
        return String.valueOf(Optional.ofNullable(String.valueOf(this.collectionValues.get(key))).orElse(""));
    }

    public JSONArray getJSONArrayValue(String key) {
        return Optional.ofNullable((JSONArray)this.collectionValues.get(key)).orElse(new JSONArray());
    }

    public boolean getBooleanValue(String key) {
        return Optional.ofNullable((Boolean)this.collectionValues.get(key)).orElse(false);
    }

    public String getId() {
        return this.getStringValue("$id");
    }

    public void setId(String id) {
        this.setValue("$id", id);
    }

    public String getName() {
        return this.getStringValue("name");
    }

    public void setName(String name) {
        this.setValue("name", name);
    }

    public JSONArray getPermision() {
        return this.getJSONArrayValue("permissions");
    }

    public void setPermision(JSONArray permision) {
        this.setValue("permissions", permision);
    }

    public void setRead(JSONArray read) {
        this.setValue("read", read);
    }

    public JSONArray getRead() {
        return this.getJSONArrayValue("read");
    }

    public void setDocumentSecurity(boolean security) {
        this.setValue("documentSecurity", security);
    }

    public boolean getDocumentSecuriry() {
        return this.getBooleanValue("documentSecurity");
    }

    public void setWrite(JSONArray write) {
        this.setValue("write", write);
    }

    public JSONArray getWrite() {
        return this.getJSONArrayValue("write");
    }

    public AppWrite getApi() {
        return this.api;
    }

    public void setApi(AppWrite api) {
        this.api = api;
    }

    public String getDatabaseId() {
        return this.getStringValue("databaseId");
    }

    public void setDatabaseId(String databaseId) {
        this.setValue("databaseId", databaseId);
    }

    public String getIdentifier() {
        return this.getStringValue("$id");
    }

    public Object getValue(String key) {
        return this.collectionValues.get(key);
    }

    public boolean isValid() {
        return false;
    }

    public void setValue(String key, Object value) {
        this.collectionValues.put(key, value);
    }

    public Map<String, Object> getAllValues() {
        return this.collectionValues;
    }

    public IECommerceEntity withApi(IECommerce api) {
        return this;
    }

    public IECommerceEntity withListener(ECommerceEventListener listener) {
        return this;
    }

    public IECommerceEntity create() {
        this.createCollectionIfNotExists().entrySet().forEach(collection -> this.setValue((String)collection.getKey(), collection.getValue()));
        return this;
    }

    public IECommerceEntity update() {
        this.updateCollection();
        return this;
    }

    public IECommerceEntity delete() {
        this.deleteCollection();
        return this;
    }

    public IECommerceEntity find(FindCriteria criteria) {
        return null;
    }

    public IECommerceEntity withWebStoreId(int webStoreId) {
        return null;
    }

    @Override
    public IAppWriteData withAppWriteApi(AppWrite api) {
        this.api = api;
        return this;
    }

    public String toString() {
        return this.collectionValues.toString();
    }

    @Override
    public Map<String, Object> list() {
        return this.listCollections();
    }

    @Override
    public Map<String, Object> get(String key) {
        return this.getCollection(key);
    }
}

