/*
 * Decompiled with CFR 0.152.
 */
package org.spin.appwrite120.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONObject;
import org.spin.appwrite120.utils.AppWrite;
import org.spin.appwrite120.utils.IAppWriteData;
import org.spin.queue.store.event.ECommerceEventListener;
import org.spin.queue.store.support.IECommerce;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.queue.store.util.FindCriteria;

public class Attribute
implements IAppWriteData {
    AppWrite api = null;
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ATTRIBUTE_SIZE = "size";
    private static final String ATTRIBUTE_REQUIRED = "required";
    private static final String ATTRIBUTE_DEFAULT = "default";
    private static final String ATTRIBUTE_ARRAY = "array";
    private static final String ATTRIBUTE_FORMAT = "format";
    private static final String ATTRIBUTE_ELEMENTS = "elements";
    private static final String ATTRIBUTE_MIN = "min";
    private static final String ATTRIBUTE_MAX = "max";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_STATUS = "status";
    public static final String ATTRIBUTE_TYPE_STRING = "string";
    public static final String ATTRIBUTE_TYPE_EMAIL = "email";
    public static final String ATTRIBUTE_TYPE_ENUM = "enum";
    public static final String ATTRIBUTE_TYPE_IP = "ip";
    public static final String ATTRIBUTE_TYPE_URL = "url";
    public static final String ATTRIBUTE_TYPE_INTEGER = "integer";
    public static final String ATTRIBUTE_TYPE_FLOAT = "float";
    public static final String ATTRIBUTE_TYPE_BOOLEAN = "boolean";
    public static final String ATTRIBUTE_TYPE_DATETIME = "datetime";
    private Map<String, Object> attributeValues = new HashMap<String, Object>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("databaseId", "");
            this.put("collectionId", "");
            this.put(Attribute.ATTRIBUTE_TYPE, Attribute.ATTRIBUTE_TYPE_STRING);
            this.put(Attribute.ATTRIBUTE_SIZE, 0);
            this.put(Attribute.ATTRIBUTE_KEY, "");
            this.put(Attribute.ATTRIBUTE_REQUIRED, false);
            this.put(Attribute.ATTRIBUTE_DEFAULT, "");
            this.put(Attribute.ATTRIBUTE_DEFAULT, "");
            this.put(Attribute.ATTRIBUTE_ARRAY, false);
            this.put(Attribute.ATTRIBUTE_ELEMENTS, new JSONArray());
            this.put(Attribute.ATTRIBUTE_MIN, Float.valueOf(Float.parseFloat("0")));
            this.put(Attribute.ATTRIBUTE_MAX, Float.valueOf(Float.parseFloat("0")));
        }
    };

    public Map<String, Object> createString() {
        return this.create(this.getKey(), ATTRIBUTE_TYPE_STRING);
    }

    public Map<String, Object> createEmail() {
        return this.create(this.getKey(), ATTRIBUTE_TYPE_EMAIL);
    }

    public Map<String, Object> createEnum() {
        return this.create(this.getKey(), ATTRIBUTE_TYPE_ENUM);
    }

    public Map<String, Object> createIP() {
        return this.create(this.getKey(), ATTRIBUTE_TYPE_IP);
    }

    public Map<String, Object> createURL() {
        return this.create(this.getKey(), ATTRIBUTE_TYPE_URL);
    }

    public Map<String, Object> createInteger() {
        return this.create(this.getKey(), ATTRIBUTE_TYPE_INTEGER);
    }

    public Map<String, Object> createFloat() {
        return this.create(this.getKey(), ATTRIBUTE_TYPE_FLOAT);
    }

    public Map<String, Object> createBoolean() {
        return this.create(this.getKey(), ATTRIBUTE_TYPE_BOOLEAN);
    }

    @Override
    public Map<String, Object> parseOutputData(JSONObject data) {
        Optional<JSONObject> maybeResponseData = Optional.ofNullable(data);
        HashMap<String, Object> parsedData = new HashMap<String, Object>();
        maybeResponseData.ifPresent(responseData -> {
            if (responseData.toMap().get("error") == null) {
                if (this.api.getAction().equals("L")) {
                    Optional<JSONArray> maybeAttributes = Optional.ofNullable(responseData.getJSONArray("attributes"));
                    maybeAttributes.ifPresent(AttributesObj -> AttributesObj.forEach(attributeObj -> {
                        JSONObject attribute = (JSONObject)attributeObj;
                        parsedData.put(attribute.getString(ATTRIBUTE_KEY), this.parseDataFromJson(attribute));
                    }));
                } else if (this.api.getAction().equals("C")) {
                    JSONObject attribute = responseData;
                    parsedData.put(attribute.getString(ATTRIBUTE_KEY), this.parseDataFromJson(attribute));
                }
            }
        });
        this.api.clearPaths();
        return parsedData;
    }

    private HashMap<String, Object> parseDataFromJson(JSONObject data) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put(ATTRIBUTE_KEY, data.getString(ATTRIBUTE_KEY));
        item.put(ATTRIBUTE_TYPE, data.getString(ATTRIBUTE_TYPE));
        item.put(ATTRIBUTE_STATUS, data.getString(ATTRIBUTE_STATUS));
        item.put(ATTRIBUTE_REQUIRED, data.getBoolean(ATTRIBUTE_REQUIRED));
        item.put(ATTRIBUTE_ARRAY, data.getBoolean(ATTRIBUTE_ARRAY));
        if (ATTRIBUTE_TYPE_STRING.equals(data.getString(ATTRIBUTE_TYPE)) && !data.isNull(ATTRIBUTE_DEFAULT)) {
            item.put(ATTRIBUTE_DEFAULT, data.getString(ATTRIBUTE_DEFAULT));
        } else if (ATTRIBUTE_TYPE_INTEGER.equals(data.getString(ATTRIBUTE_TYPE)) && !data.isNull(ATTRIBUTE_DEFAULT)) {
            item.put(ATTRIBUTE_DEFAULT, data.getInt(ATTRIBUTE_DEFAULT));
        } else if (ATTRIBUTE_TYPE_FLOAT.equals(data.getString(ATTRIBUTE_TYPE)) && !data.isNull(ATTRIBUTE_DEFAULT)) {
            item.put(ATTRIBUTE_DEFAULT, Float.valueOf(data.getFloat(ATTRIBUTE_DEFAULT)));
        }
        if (ATTRIBUTE_TYPE_INTEGER.equals(data.getString(ATTRIBUTE_TYPE))) {
            item.put(ATTRIBUTE_MIN, data.getInt(ATTRIBUTE_MIN));
        } else if (ATTRIBUTE_TYPE_FLOAT.equals(data.getString(ATTRIBUTE_TYPE))) {
            item.put(ATTRIBUTE_MIN, Float.valueOf(data.getFloat(ATTRIBUTE_MIN)));
        }
        if (ATTRIBUTE_TYPE_INTEGER.equals(data.getString(ATTRIBUTE_TYPE))) {
            item.put(ATTRIBUTE_MAX, data.getInt(ATTRIBUTE_MAX));
        } else if (ATTRIBUTE_TYPE_FLOAT.equals(data.getString(ATTRIBUTE_TYPE))) {
            item.put(ATTRIBUTE_MAX, Float.valueOf(data.getFloat(ATTRIBUTE_MAX)));
        }
        return item;
    }

    public Map<String, Object> createAttribute() {
        return this.create(this.getType());
    }

    public Map<String, Object> create(String attributeType) {
        this.api.withPath("databases");
        this.api.withPath(this.getDatabaseId());
        this.api.withPath("collections");
        this.api.withPath(this.getCollectionId());
        this.api.withPath("attributes");
        this.api.withPath(attributeType);
        this.api.withRequestType("POST");
        this.api.withDataToSend("databaseId", this.getDatabaseId());
        this.api.withDataToSend("collectionId", this.getCollectionId());
        this.api.withDataToSend(ATTRIBUTE_KEY, this.getKey());
        this.api.withDataToSend(ATTRIBUTE_REQUIRED, this.isRequired());
        this.api.withDataToSend(ATTRIBUTE_ARRAY, this.isArray());
        if (attributeType.equals(ATTRIBUTE_TYPE_STRING)) {
            this.api.withDataToSend(ATTRIBUTE_SIZE, this.getSize());
            this.api.withDataToSend(ATTRIBUTE_DEFAULT, this.getDefaultValue());
        }
        if (attributeType.equals(ATTRIBUTE_TYPE_DATETIME)) {
            this.api.withDataToSend(ATTRIBUTE_DEFAULT, this.getDefaultValue());
        }
        if (attributeType.equals(ATTRIBUTE_TYPE_ENUM)) {
            this.api.withDataToSend(ATTRIBUTE_ELEMENTS, this.getElements());
            this.api.withDataToSend(ATTRIBUTE_DEFAULT, this.getDefaultValue());
        }
        if (attributeType.equals(ATTRIBUTE_TYPE_INTEGER) || attributeType.equals(ATTRIBUTE_TYPE_FLOAT)) {
            if (this.getMinValue() > 0.0f) {
                this.api.withDataToSend(ATTRIBUTE_MIN, Float.valueOf(this.getMinValue()));
            }
            if (this.getMaxValue() > 0.0f) {
                this.api.withDataToSend(ATTRIBUTE_MAX, Float.valueOf(this.getMaxValue()));
            }
            if (!this.getDefaultValue().isEmpty()) {
                if (attributeType.equals(ATTRIBUTE_TYPE_INTEGER)) {
                    this.api.withDataToSend(ATTRIBUTE_DEFAULT, Integer.parseInt(this.getDefaultValue()));
                } else {
                    this.api.withDataToSend(ATTRIBUTE_DEFAULT, Float.valueOf(Float.parseFloat(this.getDefaultValue())));
                }
            }
        }
        JSONObject data = this.api.getOutputData();
        this.api.setAction("C");
        return this.parseOutputData(data);
    }

    public Map<String, Object> create(String attributeKey, String attributeType) {
        this.setKey(attributeKey);
        AtomicReference<Object> responseParsed = new AtomicReference<Object>(null);
        this.list().entrySet().stream().filter(val -> ((Map)Optional.ofNullable((Map)val.getValue()).orElse(new HashMap())).get("name").toString().equals(attributeKey)).forEach(collectionMap -> {
            HashMap result = new HashMap();
            this.setId((String)collectionMap.getKey());
            result.put(collectionMap.getKey(), collectionMap.getValue());
            responseParsed.set(result);
        });
        return Optional.ofNullable(responseParsed.get()).orElseGet(() -> this.create(attributeType));
    }

    public Map<String, Object> listAttributes() {
        this.api.withPath("databases");
        this.api.withPath(this.getDatabaseId());
        this.api.withPath("collections");
        this.api.withPath(this.getCollectionId());
        this.api.withPath("attributes");
        this.api.withRequestType("GET");
        JSONObject data = this.api.getOutputData();
        this.api.setAction("L");
        return this.parseOutputData(data);
    }

    public Map<String, Object> getAttribute() {
        this.api.withPath("databases");
        this.api.withPath(this.getDatabaseId());
        this.api.withPath("collections");
        this.api.withPath(this.getCollectionId());
        this.api.withPath("attributes");
        this.api.withPath(this.getKey());
        this.api.withRequestType("GET");
        JSONObject data = this.api.getOutputData();
        this.api.setAction("G");
        return this.parseOutputData(data);
    }

    public Map<String, Object> deleteAttribute() {
        this.api.withPath("databases");
        this.api.withPath(this.getDatabaseId());
        this.api.withPath("collections");
        this.api.withPath(this.getCollectionId());
        this.api.withPath("attributes");
        this.api.withPath(this.getKey());
        this.api.withRequestType("DELETE");
        JSONObject data = this.api.getOutputData();
        this.api.setAction("D");
        return this.parseOutputData(data);
    }

    public int getIntValue(String key) {
        return Integer.valueOf(Optional.ofNullable(String.valueOf(this.attributeValues.get(key))).orElse("0"));
    }

    public String getStringValue(String key) {
        return String.valueOf(Optional.ofNullable(String.valueOf(this.attributeValues.get(key))).orElse(""));
    }

    public boolean getBooleanValue(String key) {
        return Optional.ofNullable((Boolean)this.attributeValues.get(key)).orElse(false);
    }

    public String getId() {
        return this.getStringValue(ATTRIBUTE_KEY);
    }

    public void setId(String id) {
        this.setValue(ATTRIBUTE_KEY, id);
    }

    public AppWrite getApi() {
        return this.api;
    }

    public void setApi(AppWrite api) {
        this.api = api;
    }

    public String getDatabaseId() {
        return this.getStringValue("databaseId");
    }

    public void setDatabaseId(String databaseId) {
        this.setValue("databaseId", databaseId);
    }

    public String getCollectionId() {
        return this.getStringValue("collectionId");
    }

    public void setCollectionId(String collectionId) {
        this.setValue("collectionId", collectionId);
    }

    public String getKey() {
        return this.getStringValue(ATTRIBUTE_KEY);
    }

    public void setKey(String key) {
        this.setValue(ATTRIBUTE_KEY, key);
    }

    public int getSize() {
        return this.getIntValue(ATTRIBUTE_SIZE);
    }

    public void setSize(int size) {
        this.setValue(ATTRIBUTE_SIZE, size);
    }

    public boolean isRequired() {
        return this.getBooleanValue(ATTRIBUTE_REQUIRED);
    }

    public void setRequired(boolean isRequired) {
        this.setValue(ATTRIBUTE_REQUIRED, isRequired);
    }

    public String getDefaultValue() {
        return this.getStringValue(ATTRIBUTE_DEFAULT);
    }

    public void setDefaultValue(String defaultValue) {
        this.setValue(ATTRIBUTE_DEFAULT, defaultValue);
    }

    public boolean isArray() {
        return this.getBooleanValue(ATTRIBUTE_ARRAY);
    }

    public void setArray(boolean isArray) {
        this.setValue(ATTRIBUTE_ARRAY, isArray);
    }

    public JSONArray getElements() {
        return Optional.ofNullable((JSONArray)this.getValue(ATTRIBUTE_ELEMENTS)).orElse(new JSONArray());
    }

    public void setElements(JSONArray elements) {
        this.setValue(ATTRIBUTE_ELEMENTS, elements);
    }

    public float getMinValue() {
        return Optional.ofNullable((Float)this.getValue(ATTRIBUTE_MIN)).orElse(Float.valueOf(Float.parseFloat("0"))).floatValue();
    }

    public void setMinValue(float minValue) {
        this.setValue(ATTRIBUTE_MIN, Float.valueOf(minValue));
    }

    public float getMaxValue() {
        return Optional.ofNullable((Float)this.getValue(ATTRIBUTE_MAX)).orElse(Float.valueOf(Float.parseFloat("0"))).floatValue();
    }

    public void setMaxValue(float maxValue) {
        this.setValue(ATTRIBUTE_MAX, Float.valueOf(maxValue));
    }

    public void setType(String type) {
        this.setValue(ATTRIBUTE_TYPE, type);
    }

    public String getType() {
        return this.getStringValue(ATTRIBUTE_TYPE);
    }

    public String getIdentifier() {
        return this.getStringValue(ATTRIBUTE_KEY);
    }

    public Object getValue(String key) {
        return this.attributeValues.get(key);
    }

    public boolean isValid() {
        return false;
    }

    public void setValue(String key, Object value) {
        this.attributeValues.put(key, value);
    }

    public Map<String, Object> getAllValues() {
        return this.attributeValues;
    }

    public IECommerceEntity withApi(IECommerce api) {
        return this;
    }

    public IECommerceEntity withListener(ECommerceEventListener listener) {
        return this;
    }

    public IECommerceEntity create() {
        this.createAttribute().entrySet().forEach(attribute -> this.setValue((String)attribute.getKey(), attribute.getValue()));
        this.api.setInputData(new JSONObject());
        return this;
    }

    public IECommerceEntity update() {
        return this;
    }

    public IECommerceEntity delete() {
        this.deleteAttribute();
        return this;
    }

    public IECommerceEntity find(FindCriteria criteria) {
        return null;
    }

    public IECommerceEntity withWebStoreId(int webStoreId) {
        return null;
    }

    @Override
    public IAppWriteData withAppWriteApi(AppWrite api) {
        this.api = api;
        return this;
    }

    public String toString() {
        return this.attributeValues.toString();
    }

    @Override
    public Map<String, Object> list() {
        return this.listAttributes();
    }

    @Override
    public Map<String, Object> get(String key) {
        this.setId(key);
        return this.getAttribute();
    }
}

