/*
 * Decompiled with CFR 0.152.
 */
package org.spin.appwrite120.utils;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import javax.ws.rs.core.MediaType;
import org.compiere.model.MStore;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.spin.appwrite120.utils.IAppWrite;
import org.spin.model.MADAppRegistration;
import org.spin.model.MADTokenDefinition;
import org.spin.queue.store.support.IECommerce;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.queue.store.util.IECommerceImporter;
import org.spin.restapi.util.RestAPIAbstract;

public abstract class AppWrite
extends RestAPIAbstract
implements IAppWrite {
    private MADAppRegistration appRegistration = null;
    private int registrationId = 0;
    private String tokenType = "";
    private String baseURL = "";
    private String urlPATH = "";
    private String projectId = "";
    private String action = "";

    public int getAppRegistrationId() {
        return this.registrationId;
    }

    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
        this.appRegistration = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getAppRegistrationId(), null);
        this.baseURL = this.appRegistration.getHost();
        this.tokenType = this.appRegistration.getParameterValue("TOKEN_TYPE");
        this.projectId = this.appRegistration.getParameterValue("PROJECT_ID");
        this.setUrlPATH(this.appRegistration.getParameterValue("URL_PATH"));
        this.setUrl(this.baseURL);
        this.withPath(this.getUrlPATH());
        this.withHeader("X-Appwrite-Project", this.projectId);
        this.withHeader("Content-Type", MediaType.APPLICATION_JSON_TYPE);
        this.withRequest(MediaType.APPLICATION_JSON_TYPE);
        Optional<MADTokenDefinition> maybeTokenDefinition = Optional.ofNullable(MADTokenDefinition.getByTokenType((Properties)this.appRegistration.getCtx(), (String)this.tokenType, (String)this.appRegistration.get_TrxName()));
        maybeTokenDefinition.ifPresent(tokenDefinition -> {
            Optional<PO> maybeToken = Optional.ofNullable(new Query(this.appRegistration.getCtx(), "AD_Token", "AD_TokenDefinition_ID".concat("= ? AND IsActive = 'Y'"), this.appRegistration.get_TrxName()).setParameters(new Object[]{tokenDefinition.get_ID()}).first());
            maybeToken.ifPresent(token -> this.withHeader("X-Appwrite-key", token.getTokenValue()));
        });
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public String getUrlPATH() {
        return this.urlPATH;
    }

    public void setUrlPATH(String urlPATH) {
        this.urlPATH = urlPATH;
    }

    public String testConnection() {
        return null;
    }

    public void clearPaths() {
        this.setPaths(new ArrayList());
        this.withPath(this.getUrlPATH());
        this.setOutputData(null);
    }

    public String getParameterValue(String parameterName) {
        return this.appRegistration.getParameterValue(parameterName);
    }

    public IECommerce create(IECommerceEntity entity) throws Exception {
        entity.create();
        return this;
    }

    public IECommerce update(IECommerceEntity entity) throws Exception {
        entity.update();
        return this;
    }

    public IECommerce delete(IECommerceEntity entity) throws Exception {
        entity.delete();
        return null;
    }

    public boolean exist(IECommerceEntity entity) throws Exception {
        return false;
    }

    public IECommerce connect() throws Exception {
        return null;
    }

    public IECommerce close() throws Exception {
        return null;
    }

    public IECommerceImporter getImporter(String tableName) {
        return null;
    }

    public int getApiId() {
        return 0;
    }

    @Override
    public IAppWrite withWebStore(MStore store) {
        return this;
    }
}

