/*
 * Decompiled with CFR 0.152.
 */
package org.spin.appwrite015.utils;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.MultivaluedHashMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.spin.appwrite015.utils.AppWrite;
import org.spin.appwrite015.utils.AppWriteUtils;
import org.spin.appwrite015.utils.IAppWriteData;
import org.spin.queue.store.event.ECommerceEventListener;
import org.spin.queue.store.support.IECommerce;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.queue.store.util.FindCriteria;

public class Document
implements IAppWriteData {
    AppWrite api = null;
    public static final String ATTRIBUTE_DOCUMENT_ID = "documentId";
    public static final String ATTRIBUTE_DATA = "data";
    private Map<String, Object> documentValues = new HashMap<String, Object>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("databaseId", "");
            this.put("collectionId", "");
            this.put(Document.ATTRIBUTE_DOCUMENT_ID, "unique()");
            this.put("$id", "");
            this.put(Document.ATTRIBUTE_DATA, new JSONObject());
            this.put("read", AppWriteUtils.ATTRIBUTE_DEFAULT_VALUE_ROLE_ALL);
            this.put("write", AppWriteUtils.ATTRIBUTE_DEFAULT_VALUE_ROLE_ALL);
            this.put("permission", "collection");
        }
    };

    @Override
    public Map<String, Object> parseOutputData(JSONObject data) {
        Optional<JSONObject> maybeResponseData = Optional.ofNullable(data);
        HashMap<String, Object> parsedData = new HashMap<String, Object>();
        maybeResponseData.ifPresent(responseData -> {
            if (responseData.toMap().get("error") == null) {
                if (this.api.getAction().equals("L")) {
                    Optional<JSONArray> maybeDocuments = Optional.ofNullable(responseData.getJSONArray("documents"));
                    maybeDocuments.ifPresent(documentsObj -> documentsObj.forEach(documentObj -> {
                        JSONObject document = (JSONObject)documentObj;
                        parsedData.put(document.getString("$id"), this.parseDataFromJson(document));
                    }));
                } else if (this.api.getAction().equals("C") || this.api.getAction().equals("U")) {
                    JSONObject documentObj = responseData;
                    parsedData.put(documentObj.getString("$id"), this.parseDataFromJson(documentObj));
                    this.api.clearPaths();
                } else if (this.api.getAction().equals("D")) {
                    JSONObject documentObj = responseData;
                    HashMap<String, String> item = new HashMap<String, String>();
                    item.put("response", documentObj.getString("response"));
                    parsedData.put("response", item);
                    this.api.clearPaths();
                }
            } else {
                this.api.clearPaths();
            }
        });
        return parsedData;
    }

    public HashMap<String, Object> parseDataFromJson(JSONObject data) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("$id", data.getString("$id"));
        item.put("$collection", data.getString("$collection"));
        item.put("$createdAt", new Timestamp(data.getLong("$createdAt")));
        item.put("$updatedAt", new Timestamp(data.getLong("$updatedAt")));
        item.put("$read", data.getJSONArray("$read"));
        item.put("$write", data.getJSONArray("$write"));
        return item;
    }

    public Map<String, Object> createDocument() {
        this.api.withPath("databases");
        this.api.withPath(this.getDatabaseId());
        this.api.withPath("collections");
        this.api.withPath(this.getCollectionId());
        this.api.withPath("documents");
        this.api.withRequestType("POST");
        this.api.withDataToSend("databaseId", this.getDatabaseId());
        this.api.withDataToSend("collectionId", this.getCollectionId());
        this.api.withDataToSend(ATTRIBUTE_DOCUMENT_ID, this.getId());
        this.api.withDataToSend(ATTRIBUTE_DATA, this.getData());
        Optional.ofNullable(this.getPermision()).ifPresent(permision -> {
            if (permision.equals("document")) {
                this.api.withDataToSend("read", this.getRead());
                this.api.withDataToSend("write", this.getWrite());
            }
        });
        JSONObject data = this.api.getOutputData();
        this.api.setAction("C");
        return this.parseOutputData(data);
    }

    public Map<String, Object> listDocuments() {
        this.api.withPath("databases");
        this.api.withPath(this.getDatabaseId());
        this.api.withPath("collections");
        this.api.withPath(this.getCollectionId());
        this.api.withPath("documents");
        this.api.withRequestType("GET");
        MultivaluedHashMap currentParameters = this.api.getParameters();
        MultivaluedHashMap newParameters = new MultivaluedHashMap();
        HashMap<String, Object> documents = new HashMap<String, Object>();
        newParameters.putAll((Map)currentParameters);
        int totalPage = 1;
        int records = 25;
        for (int currentPage = 0; currentPage <= totalPage; ++currentPage) {
            newParameters.add((Object)"limit", (Object)records);
            newParameters.add((Object)"offset", (Object)(records * currentPage));
            this.api.setParameters(newParameters);
            JSONObject data = this.api.getOutputData();
            this.api.setAction("L");
            totalPage = data.getInt("total") / records;
            documents.putAll(this.parseOutputData(data));
            this.api.setOutputData(null);
        }
        this.api.setParameters(currentParameters);
        this.api.clearPaths();
        return documents;
    }

    public Map<String, Object> getDocument() {
        this.api.withPath("databases");
        this.api.withPath(this.getDatabaseId());
        this.api.withPath("collections");
        this.api.withPath(this.getCollectionId());
        this.api.withPath("documents");
        this.api.withPath(this.getId());
        this.api.withRequestType("GET");
        JSONObject data = this.api.getOutputData();
        this.api.setAction("G");
        return this.parseOutputData(data);
    }

    public Map<String, Object> updateDocument() {
        this.api.withPath("databases");
        this.api.withPath(this.getDatabaseId());
        this.api.withPath("collections");
        this.api.withPath(this.getCollectionId());
        this.api.withPath("documents");
        this.api.withPath(this.getId());
        this.api.withRequestType("PATCH");
        this.api.withDataToSend("databaseId", this.getDatabaseId());
        this.api.withDataToSend("collectionId", this.getCollectionId());
        this.api.withDataToSend(ATTRIBUTE_DOCUMENT_ID, this.getId());
        this.api.withDataToSend(ATTRIBUTE_DATA, this.getData());
        JSONObject data = this.api.getOutputData();
        this.api.setAction("U");
        return this.parseOutputData(data);
    }

    public Map<String, Object> deleteDocument() {
        this.api.withPath("databases");
        this.api.withPath(this.getDatabaseId());
        this.api.withPath("collections");
        this.api.withPath(this.getCollectionId());
        this.api.withPath("documents");
        this.api.withPath(this.getId());
        this.api.withRequestType("DELETE");
        JSONObject data = this.api.getOutputData();
        this.api.setAction("D");
        return this.parseOutputData(data);
    }

    public int getIntValue(String key) {
        return Integer.valueOf(Optional.ofNullable(String.valueOf(this.documentValues.get(key))).orElse("0"));
    }

    public String getStringValue(String key) {
        return String.valueOf(Optional.ofNullable(String.valueOf(this.documentValues.get(key))).orElse(""));
    }

    public boolean getBooleanValue(String key) {
        return Optional.ofNullable((Boolean)this.documentValues.get(key)).orElse(false);
    }

    public String getId() {
        return this.getStringValue("$id");
    }

    public void setId(String id) {
        this.setValue("$id", id);
    }

    public Map<String, Object> getData() {
        Object data = this.getValue(ATTRIBUTE_DATA);
        if (data != null && data instanceof Map) {
            return (Map)data;
        }
        return new HashMap<String, Object>();
    }

    public void setData(Map<String, Object> documentData) {
        this.setValue(ATTRIBUTE_DATA, documentData);
    }

    public AppWrite getApi() {
        return this.api;
    }

    public void setApi(AppWrite api) {
        this.api = api;
    }

    public String getDatabaseId() {
        return this.getStringValue("databaseId");
    }

    public void setDatabaseId(String databaseId) {
        this.setValue("databaseId", databaseId);
    }

    public String getCollectionId() {
        return this.getStringValue("collectionId");
    }

    public void setCollectionId(String collectionId) {
        this.setValue("collectionId", collectionId);
    }

    public String getPermision() {
        return this.getStringValue("permission");
    }

    public void setPermisions(String permisions) {
        this.setValue("permission", permisions);
    }

    public JSONArray getRead() {
        return Optional.ofNullable((JSONArray)this.getValue("read")).orElse(new JSONArray());
    }

    public void setRead(JSONArray read) {
        this.setValue("read", read);
    }

    public JSONArray getWrite() {
        return Optional.ofNullable((JSONArray)this.getValue("write")).orElse(new JSONArray());
    }

    public void setWrite(JSONArray write) {
        this.setValue("permission", write);
    }

    public String getIdentifier() {
        return this.getStringValue("$id");
    }

    public Object getValue(String key) {
        return this.documentValues.get(key);
    }

    public boolean isValid() {
        return false;
    }

    public void setValue(String key, Object value) {
        this.documentValues.put(key, value);
    }

    public Map<String, Object> getAllValues() {
        return this.documentValues;
    }

    public IECommerceEntity withApi(IECommerce api) {
        return this;
    }

    public IECommerceEntity withListener(ECommerceEventListener listener) {
        return this;
    }

    public IECommerceEntity create() {
        this.createDocument().entrySet().forEach(attribute -> this.setValue((String)attribute.getKey(), attribute.getValue()));
        this.api.setInputData(new JSONObject());
        return this;
    }

    public IECommerceEntity update() {
        this.updateDocument();
        return this;
    }

    public IECommerceEntity delete() {
        this.deleteDocument();
        return this;
    }

    public IECommerceEntity find(FindCriteria criteria) {
        return null;
    }

    public IECommerceEntity withWebStoreId(int webStoreId) {
        return null;
    }

    @Override
    public IAppWriteData withAppWriteApi(AppWrite api) {
        this.api = api;
        return this;
    }

    public String toString() {
        return this.documentValues.toString();
    }

    @Override
    public Map<String, Object> list() {
        return this.listDocuments();
    }

    @Override
    public Map<String, Object> get(String key) {
        this.setId(key);
        return this.getDocument();
    }
}

