/*
 * Decompiled with CFR 0.152.
 */
package org.spin.appwrite015.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONObject;
import org.spin.appwrite015.utils.AppWrite;
import org.spin.appwrite015.utils.IAppWriteData;
import org.spin.queue.store.event.ECommerceEventListener;
import org.spin.queue.store.support.IECommerce;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.queue.store.util.FindCriteria;

public class Database
implements IAppWriteData {
    private AppWrite api = null;
    private Map<String, Object> databaseValues = new HashMap<String, Object>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("$id", "");
            this.put("databaseId", "unique()");
            this.put("name", "");
        }
    };

    public static Database newInstance() {
        return new Database();
    }

    @Override
    public Map<String, Object> parseOutputData(JSONObject data) {
        Optional<JSONObject> maybeResponseData = Optional.ofNullable(data);
        HashMap<String, Object> parsedData = new HashMap<String, Object>();
        maybeResponseData.ifPresent(responseData -> {
            if (this.api.getAction().equals("L")) {
                Optional<JSONArray> maybeDatabases = Optional.ofNullable(responseData.getJSONArray("databases"));
                maybeDatabases.ifPresent(databasesObj -> databasesObj.forEach(databaseObj -> {
                    JSONObject database = (JSONObject)databaseObj;
                    HashMap<String, String> item = new HashMap<String, String>();
                    item.put("name", database.getString("name"));
                    item.put("$id", database.getString("$id"));
                    parsedData.put(database.getString("$id"), item);
                }));
            } else if (this.api.getAction().equals("G") || this.api.getAction().equals("C") || this.api.getAction().equals("U")) {
                JSONObject database = responseData;
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("name", database.getString("name"));
                item.put("$id", database.getString("$id"));
                this.setId(database.getString("$id"));
                parsedData.put(database.getString("$id"), item);
            } else if (this.api.getAction().equals("D")) {
                JSONObject database = responseData;
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("response", database.getString("response"));
                parsedData.put("response", item);
            }
        });
        this.api.clearPaths();
        return parsedData;
    }

    private Map<String, Object> listDatabases() {
        this.api.withPath("databases");
        this.api.withRequestType("GET");
        JSONObject data = this.api.getOutputData();
        this.api.setAction("L");
        return this.parseOutputData(data);
    }

    private Map<String, Object> getDatabase(String databaseid) {
        this.api.withPath("databases");
        this.api.withPath(databaseid);
        this.api.withRequestType("GET");
        JSONObject data = this.api.getOutputData();
        this.api.setAction("G");
        return this.parseOutputData(data);
    }

    private Map<String, Object> createDatabaseIfNotExists() {
        AtomicReference<Object> responseParsed = new AtomicReference<Object>(null);
        String databaseName = this.getName();
        this.listDatabases().entrySet().stream().filter(val -> ((Map)Optional.ofNullable((Map)val.getValue()).orElse(new HashMap())).get("name").toString().equals(databaseName)).forEach(dbase -> {
            HashMap result = new HashMap();
            this.setId((String)dbase.getKey());
            result.put(dbase.getKey(), dbase.getValue());
            responseParsed.set(result);
        });
        return Optional.ofNullable(responseParsed.get()).orElseGet(() -> this.createDatabase());
    }

    private Map<String, Object> createDatabase() {
        this.api.withPath("databases");
        this.api.withRequestType("POST");
        this.api.withDataToSend("databaseId", this.getDatabaseId());
        this.api.withDataToSend("name", this.getName());
        JSONObject data = this.api.getOutputData();
        this.api.setAction("C");
        return this.parseOutputData(data);
    }

    private Map<String, Object> update(String databaseid, String databaseName) {
        this.api.withPath("databases");
        this.api.withPath(databaseid);
        this.api.withRequestType("PUT");
        this.api.withDataToSend("name", databaseName);
        JSONObject data = this.api.getOutputData();
        this.api.setAction("U");
        return this.parseOutputData(data);
    }

    private Map<String, Object> delete(String databaseid) {
        this.api.withPath("databases");
        this.api.withPath(databaseid);
        this.api.withRequestType("DELETE");
        JSONObject data = this.api.getOutputData();
        this.api.setAction("D");
        return this.parseOutputData(data);
    }

    public String getStringValue(String key) {
        return String.valueOf(Optional.ofNullable(String.valueOf(this.databaseValues.get(key))).orElse(""));
    }

    public String getDatabaseId() {
        return this.getStringValue("databaseId");
    }

    public String getName() {
        return this.getStringValue("name");
    }

    public void setId(String id) {
        this.databaseValues.put("$id", id);
    }

    public String getIdentifier() {
        return this.getStringValue("$id");
    }

    public Object getValue(String key) {
        return this.databaseValues.get(key);
    }

    public boolean isValid() {
        return false;
    }

    public void setValue(String key, Object value) {
        this.databaseValues.put(key, value);
    }

    public Map<String, Object> getAllValues() {
        return this.databaseValues;
    }

    public IECommerceEntity withApi(IECommerce api) {
        return this;
    }

    public IECommerceEntity withListener(ECommerceEventListener listener) {
        return this;
    }

    public IECommerceEntity create() {
        this.createDatabaseIfNotExists().entrySet().forEach(database -> this.setValue((String)database.getKey(), database.getValue()));
        return this;
    }

    public IECommerceEntity update() {
        this.update(this.getIdentifier(), this.getName());
        return this;
    }

    public IECommerceEntity delete() {
        this.delete(this.getIdentifier());
        return this;
    }

    public IECommerceEntity find(FindCriteria criteria) {
        return null;
    }

    public IECommerceEntity withWebStoreId(int webStoreId) {
        return this;
    }

    @Override
    public IAppWriteData withAppWriteApi(AppWrite api) {
        this.api = api;
        return this;
    }

    public String toString() {
        return this.databaseValues.toString();
    }

    @Override
    public Map<String, Object> list() {
        return this.listDatabases();
    }

    @Override
    public Map<String, Object> get(String key) {
        return this.getDatabase(key);
    }
}

