/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.repo.PersistenceService;
import net.sf.jasperreports.repo.PersistenceUtil;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.Resource;
import net.sf.jasperreports.repo.ResourceInfo;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import net.sf.jasperreports.repo.StandardResourceInfo;
import net.sf.jasperreports.repo.StreamRepositoryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultRepositoryService
implements StreamRepositoryService {
    private static final Log log = LogFactory.getLog(DefaultRepositoryService.class);
    public static final String PROPERTY_FILES_ENABLED = "net.sf.jasperreports.default.file.repository.enabled";
    public static final String EXCEPTION_MESSAGE_KEY_NOT_IMPLEMENTED = "repo.default.not.implemented";
    protected JasperReportsContext jasperReportsContext;
    private boolean filesEnabled;
    protected ClassLoader classLoader;
    protected URLStreamHandlerFactory urlHandlerFactory;
    protected FileResolver fileResolver;

    public DefaultRepositoryService(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
        this.filesEnabled = JRPropertiesUtil.getInstance(jasperReportsContext).getBooleanProperty(PROPERTY_FILES_ENABLED, true);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setURLStreamHandlerFactory(URLStreamHandlerFactory urlHandlerFactory) {
        this.urlHandlerFactory = urlHandlerFactory;
    }

    public void setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    @Override
    public InputStream getInputStream(String uri) {
        return this.getInputStream(SimpleRepositoryContext.of(this.jasperReportsContext), uri);
    }

    @Override
    public InputStream getInputStream(RepositoryContext context, String uri) {
        try {
            URL url = JRResourcesUtil.createURL(uri, this.urlHandlerFactory);
            if (url != null) {
                return JRLoader.getInputStream(url);
            }
            File file = this.resolveFile(context, uri);
            if (file != null) {
                return JRLoader.getInputStream(file);
            }
            url = JRResourcesUtil.findClassLoaderResource(uri, this.classLoader);
            if (url != null) {
                return JRLoader.getInputStream(url);
            }
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        return null;
    }

    protected File resolveFile(RepositoryContext context, String uri) {
        if (this.fileResolver != null) {
            return this.fileResolver.resolveFile(uri);
        }
        if (this.filesEnabled) {
            return JRResourcesUtil.resolveFile(context, uri);
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream(String uri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource getResource(String uri) {
        throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NOT_IMPLEMENTED, (Object[])null);
    }

    @Override
    public void saveResource(String uri, Resource resource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K extends Resource> K getResource(String uri, Class<K> resourceType) {
        return this.getResource(SimpleRepositoryContext.of(this.jasperReportsContext), uri, resourceType);
    }

    @Override
    public <K extends Resource> K getResource(RepositoryContext context, String uri, Class<K> resourceType) {
        PersistenceService persistenceService = PersistenceUtil.getInstance(this.jasperReportsContext).getService(DefaultRepositoryService.class, resourceType);
        if (persistenceService != null) {
            return (K)persistenceService.load(context, uri, this);
        }
        return null;
    }

    @Override
    public ResourceInfo getResourceInfo(RepositoryContext context, String location) {
        URL url = JRResourcesUtil.createURL(location, this.urlHandlerFactory);
        if (url != null) {
            return null;
        }
        File file = this.resolveFile(context, location);
        if (file != null) {
            try {
                Path path = file.toPath().toRealPath(new LinkOption[0]);
                return StandardResourceInfo.from(path);
            }
            catch (IOException e) {
                log.warn("Failed to resolve real path for file " + file, e);
                return StandardResourceInfo.from(file);
            }
        }
        return null;
    }
}

