/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.phantomjs;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.phantomjs.ProcessConnection;
import net.sf.jasperreports.phantomjs.ProcessDirector;
import net.sf.jasperreports.phantomjs.ProcessOutputReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PhantomJSProcess {
    private static final Log log = LogFactory.getLog(PhantomJSProcess.class);
    public static final String EXCEPTION_MESSAGE_KEY_FAILED_START = "phantomjs.failed.start";
    public static final String PHANTOMJS_CONFIRMATION_MESSAGE = "PROCESS_STARTED";
    private static final AtomicLong ID_COUNTER = new AtomicLong();
    private String id;
    private ProcessDirector director;
    private URI listenURI;
    private Process process;
    private ProcessConnection processConnection;
    private volatile boolean ended;
    private AtomicReference<Integer> exitCode = new AtomicReference();

    public PhantomJSProcess(ProcessDirector director, int listenPort) {
        this.id = "phantomjs#" + ID_COUNTER.incrementAndGet();
        this.director = director;
        this.listenURI = this.listenURI(director.getListenAddress(), listenPort);
    }

    private URI listenURI(Inet4Address listenAddress, int listenPort) {
        try {
            return new URI("http", null, listenAddress.getHostAddress(), listenPort, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new JRRuntimeException(e);
        }
    }

    public String getId() {
        return this.id;
    }

    public URI getListenURI() {
        return this.listenURI;
    }

    public void startPhantomJS() {
        String mainScriptTempName = this.director.getScriptManager().getScriptFilename("net/sf/jasperreports/phantomjs/process.js");
        String listenAddress = this.listenURI.getHost() + ":" + this.listenURI.getPort();
        int idleTimeout = this.director.getProcessIdleTimeout();
        log.info("PhantomJS process " + this.id + " starting on port " + this.listenURI.getPort());
        if (log.isDebugEnabled()) {
            log.debug(this.id + " starting phantomjs process with command: " + this.director.getPhantomjsExecutablePath() + " \"" + mainScriptTempName + "\" -listenAddress \"" + listenAddress + "\" -confirmMessage \"" + PHANTOMJS_CONFIRMATION_MESSAGE + "\" -idleTimeout " + idleTimeout + "");
        }
        ProcessBuilder pb = new ProcessBuilder(this.director.getPhantomjsExecutablePath(), mainScriptTempName, "-listenAddress", listenAddress, "-confirmMessage", PHANTOMJS_CONFIRMATION_MESSAGE, "-idleTimeout", Integer.toString(idleTimeout));
        pb.redirectErrorStream(false);
        pb.directory(this.director.getScriptManager().getTempFolder());
        try {
            this.process = pb.start();
            ProcessOutputReader outputReader = new ProcessOutputReader(this);
            outputReader.start();
            boolean started = outputReader.waitConfirmation(this.director.getProcessStartTimeout());
            if (!started) {
                log.error("PhantomJS process " + this.id + " failed to start");
                this.process.destroy();
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_FAILED_START, (Object[])null);
            }
            this.processConnection = new ProcessConnection(this.director, this);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected Process getProcess() {
        return this.process;
    }

    public ProcessConnection getProcessConnection() {
        return this.processConnection;
    }

    protected void signalEnd() {
        if (log.isDebugEnabled()) {
            log.debug(this.id + " signal end");
        }
        this.ended = true;
        if (this.exitCode.get() == null) {
            Integer exitValue;
            try {
                exitValue = this.process.exitValue();
            }
            catch (IllegalThreadStateException e) {
                if (log.isDebugEnabled()) {
                    log.debug(this.id + " waiting for exit value");
                }
                try {
                    exitValue = this.process.waitFor();
                }
                catch (InterruptedException ie) {
                    if (log.isDebugEnabled()) {
                        log.debug(this.id + " wait interrupted", e);
                    }
                    exitValue = null;
                }
            }
            if (exitValue != null && this.exitCode.compareAndSet(null, exitValue)) {
                log.info("PhantomJS process " + this.id + " done, exit value " + exitValue);
            }
        }
    }

    public boolean hasEnded() {
        return this.ended;
    }

    public void dispose() {
        if (this.processConnection != null) {
            this.processConnection.dispose();
        }
        if (this.process != null && this.exitCode.get() == null) {
            log.info("PhantomJS process " + this.id + " to be destroyed");
            this.process.destroy();
        }
    }
}

