/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import net.sf.jasperreports.engine.type.EnumUtil;
import net.sf.jasperreports.engine.type.JREnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.xml.TransformedPropertyRule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmlConstantPropertyRule
extends TransformedPropertyRule {
    private static final Log log = LogFactory.getLog(XmlConstantPropertyRule.class);
    private final NamedEnum[] values;

    public XmlConstantPropertyRule(String attributeName, JREnum[] values) {
        this(attributeName, (NamedEnum[])values);
    }

    public XmlConstantPropertyRule(String attributeName, String propertyName, JREnum[] values) {
        this(attributeName, propertyName, (NamedEnum[])values);
    }

    public XmlConstantPropertyRule(String attributeName, NamedEnum[] values) {
        super(attributeName);
        this.values = values;
    }

    public XmlConstantPropertyRule(String attributeName, String propertyName, NamedEnum[] values) {
        super(attributeName, propertyName);
        this.values = values;
    }

    @Override
    protected Object toPropertyValue(String attributeValue) {
        NamedEnum value = EnumUtil.getEnumByName((NamedEnum[])this.values, (String)attributeValue);
        if (value == null) {
            log.warn("Unrecognized attribute value \"" + attributeValue + "\" for " + this.attributeName);
        }
        return value;
    }
}

