/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.ComponentsBundle;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.component.ComponentsXmlParser;
import net.sf.jasperreports.engine.part.PartComponentsBundle;
import net.sf.jasperreports.engine.part.PartComponentsEnvironment;
import net.sf.jasperreports.engine.xml.BaseSaxParserFactory;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRReportSaxParserFactory
extends BaseSaxParserFactory {
    private static final Log log = LogFactory.getLog(JRReportSaxParserFactory.class);
    public static final String COMPILER_XML_VALIDATION = "net.sf.jasperreports.compiler.xml.validation";
    private static final ThreadLocal<ReferenceMap> GRAMMAR_POOL_CACHE = new ThreadLocal();

    public JRReportSaxParserFactory(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    protected boolean isValidating() {
        return JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(COMPILER_XML_VALIDATION);
    }

    @Override
    protected List<String> getSchemaLocations() {
        ArrayList<String> schemas = new ArrayList<String>();
        schemas.add(this.getResourceURI("net/sf/jasperreports/engine/dtds/jasperreport.xsd"));
        schemas.add(this.getResourceURI("net/sf/jasperreports/engine/dtds/jasperreport-dtd-compat.xsd"));
        Collection<ComponentsBundle> components = ComponentsEnvironment.getInstance(this.jasperReportsContext).getBundles();
        for (ComponentsBundle componentManager : components) {
            ComponentsXmlParser xmlParser = componentManager.getXmlParser();
            String schemaResource = xmlParser.getInternalSchemaResource();
            String schemaURI = schemaResource != null ? this.getResourceURI(schemaResource) : xmlParser.getPublicSchemaLocation();
            if (log.isDebugEnabled()) {
                log.debug("Adding components schema at " + schemaURI);
            }
            schemas.add(schemaURI);
        }
        Collection<PartComponentsBundle> parts = PartComponentsEnvironment.getInstance(this.jasperReportsContext).getBundles();
        for (PartComponentsBundle componentManager : parts) {
            ComponentsXmlParser xmlParser = componentManager.getXmlParser();
            String schemaResource = xmlParser.getInternalSchemaResource();
            String schemaURI = schemaResource != null ? this.getResourceURI(schemaResource) : xmlParser.getPublicSchemaLocation();
            if (log.isDebugEnabled()) {
                log.debug("Adding components schema at " + schemaURI);
            }
            schemas.add(schemaURI);
        }
        return schemas;
    }

    @Override
    protected ThreadLocal<ReferenceMap> getGrammarPoolCache() {
        return GRAMMAR_POOL_CACHE;
    }
}

