/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.query.ProcedureCallHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OracleProcedureCallHandler
implements ProcedureCallHandler {
    private static final Log log;
    private static final Class<?> ORACLE_CONNECTION_CLASS;
    private static final String URL_DATADIRECT = "jdbc:datadirect:oracle:";
    private static final String URL_TIBCO = "jdbc:tibcosoftware:oracle:";
    private static final String URL_ORACLE = "jdbc:oracle:";
    private static final String DRIVER_NAME_ORACLE = "Oracle JDBC driver";
    private static final String DRIVER_NAME_DATADIRECT = "Oracle";
    private static final String DB_PRODUCT = "oracle";
    private static final int ORACLE_CURSOR_TYPE = -10;
    private CallableStatement statement;
    private boolean isDataDirectDriver;
    private int cursorParameter = -1;

    protected static boolean isOracle(Connection connection) throws SQLException {
        String dbVendor = connection.getMetaData().getDatabaseProductName().toLowerCase();
        return DB_PRODUCT.equals(dbVendor);
    }

    @Override
    public void init(CallableStatement statement) {
        this.statement = statement;
        this.isDataDirectDriver = this.isDataDirectDriver();
        if (log.isDebugEnabled()) {
            log.debug("DataDirect driver " + this.isDataDirectDriver);
        }
    }

    protected boolean isDataDirectDriver() {
        Connection connection;
        try {
            connection = this.statement.getConnection();
        }
        catch (SQLException e) {
            log.error("Failure while detecting driver", e);
            return false;
        }
        DatabaseMetaData metaData = null;
        try {
            metaData = connection.getMetaData();
        }
        catch (SQLException e) {
            log.error("Failure while detecting driver", e);
        }
        String connectionURL = null;
        if (metaData != null) {
            try {
                connectionURL = metaData.getURL();
            }
            catch (SQLException e) {
                log.error("Failure while detecting driver", e);
            }
        }
        if (connectionURL != null) {
            if (connectionURL.contains(URL_DATADIRECT) || connectionURL.contains(URL_TIBCO)) {
                return true;
            }
            if (connectionURL.contains(URL_ORACLE)) {
                return false;
            }
        }
        if (ORACLE_CONNECTION_CLASS != null) {
            try {
                if (connection.isWrapperFor(ORACLE_CONNECTION_CLASS)) {
                    return false;
                }
            }
            catch (SQLException e) {
                log.error("Failure while detecting driver", e);
            }
        }
        if (metaData != null) {
            try {
                String driverName = metaData.getDriverName();
                if (driverName.equals(DRIVER_NAME_ORACLE)) {
                    return false;
                }
                if (driverName.equals(DRIVER_NAME_DATADIRECT)) {
                    return true;
                }
            }
            catch (SQLException e) {
                log.error("Failure while detecting driver", e);
            }
        }
        return false;
    }

    @Override
    public boolean setParameterValue(int parameterIndex, Class<?> type, Object value) throws SQLException {
        if (ResultSet.class.isAssignableFrom(type)) {
            if (this.cursorParameter > 0) {
                throw new JRRuntimeException("A stored procedure can have at most one cursor parameter : " + parameterIndex + " class " + type.getName());
            }
            this.cursorParameter = parameterIndex;
            if (this.isDataDirectDriver) {
                this.statement.setInt(parameterIndex, 0);
            } else {
                this.statement.registerOutParameter(parameterIndex, -10);
            }
            return true;
        }
        return false;
    }

    @Override
    public ResultSet execute() throws SQLException {
        boolean isResult = this.statement.execute();
        ResultSet resultSet = null;
        if (this.isDataDirectDriver) {
            while (!isResult) {
                int updateCount = this.statement.getUpdateCount();
                if (log.isDebugEnabled()) {
                    log.debug("Update count " + updateCount);
                }
                if (updateCount == -1) break;
                isResult = this.statement.getMoreResults();
            }
            if (isResult) {
                resultSet = this.statement.getResultSet();
            } else if (log.isDebugEnabled()) {
                log.debug("No ResultSet found");
            }
        } else if (this.cursorParameter > 0) {
            resultSet = (ResultSet)this.statement.getObject(this.cursorParameter);
        }
        return resultSet;
    }

    static {
        Class<?> oracleConnectionClass;
        log = LogFactory.getLog(OracleProcedureCallHandler.class);
        try {
            oracleConnectionClass = Class.forName("oracle.jdbc.OracleConnection");
        }
        catch (ClassNotFoundException e) {
            oracleConnectionClass = null;
        }
        ORACLE_CONNECTION_CLASS = oracleConnectionClass;
    }
}

