/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.CommonReturnValue;
import net.sf.jasperreports.engine.ExpressionReturnValue;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.ReturnValue;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCommonReturnValue;
import net.sf.jasperreports.engine.fill.JRFillExpressionReturnValue;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRFillVariableReturnValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FillReturnValues {
    private static final Log log = LogFactory.getLog(FillReturnValues.class);
    private final BaseReportFiller filler;
    private JRFillCommonReturnValue[] returnValues;
    private JRFillBand band;

    public FillReturnValues(JRSubreportReturnValue[] values, JRFillObjectFactory factory, BaseReportFiller filler) {
        this.filler = filler;
        if (values != null && values.length > 0) {
            ArrayList<JRFillCommonReturnValue> returnValuesList = new ArrayList<JRFillCommonReturnValue>(values.length * 2);
            for (JRSubreportReturnValue returnValue : values) {
                JRFillVariableReturnValue fillReturnValue = factory.getSubreportReturnValue(returnValue);
                fillReturnValue.addReturnValue(fillReturnValue, returnValuesList, factory, filler);
            }
            this.returnValues = new JRFillVariableReturnValue[returnValuesList.size()];
            returnValuesList.toArray(this.returnValues);
        }
    }

    public FillReturnValues(List<ReturnValue> values, JRFillObjectFactory factory, BaseReportFiller filler) {
        this.filler = filler;
        if (values != null && !values.isEmpty()) {
            ArrayList<JRFillCommonReturnValue> returnValuesList = new ArrayList<JRFillCommonReturnValue>(values.size() * 2);
            for (ReturnValue returnValue : values) {
                JRFillVariableReturnValue fillReturnValue = factory.getReturnValue(returnValue);
                fillReturnValue.addReturnValue(fillReturnValue, returnValuesList, factory, filler);
            }
            this.returnValues = new JRFillCommonReturnValue[returnValuesList.size()];
            returnValuesList.toArray(this.returnValues);
        }
    }

    public FillReturnValues(ExpressionReturnValue[] values, JRFillObjectFactory factory, BaseReportFiller filler) {
        this.filler = filler;
        if (values != null && values.length > 0) {
            ArrayList<JRFillCommonReturnValue> returnValuesList = new ArrayList<JRFillCommonReturnValue>(values.length * 2);
            for (ExpressionReturnValue returnValue : values) {
                JRFillExpressionReturnValue fillReturnValue = factory.getReturnValue(returnValue);
                fillReturnValue.addReturnValue(fillReturnValue, returnValuesList, factory, filler);
            }
            this.returnValues = new JRFillCommonReturnValue[returnValuesList.size()];
            returnValuesList.toArray(this.returnValues);
        }
    }

    protected FillReturnValues(FillReturnValues values, JRFillCloneFactory factory) {
        this.filler = values.filler;
        this.band = values.band;
        if (values.returnValues != null) {
            this.returnValues = new JRFillCommonReturnValue[values.returnValues.length];
            for (int i = 0; i < values.returnValues.length; ++i) {
                this.returnValues[i] = new JRFillVariableReturnValue((JRFillVariableReturnValue)values.returnValues[i], factory);
            }
        }
    }

    public void setBand(JRFillBand band) {
        this.band = band;
        band.registerReturnValues(this);
    }

    public void saveReturnVariables() {
        if (log.isDebugEnabled()) {
            log.debug("saving return variables on band " + this.band);
        }
        if (this.returnValues != null && this.band != null) {
            for (int i = 0; i < this.returnValues.length; ++i) {
                String varName = this.returnValues[i].getToVariable();
                this.band.saveVariable(varName);
            }
        }
    }

    public boolean usesForReturnValue(String variableName) {
        boolean used = false;
        if (this.returnValues != null) {
            for (int j = 0; j < this.returnValues.length; ++j) {
                JRFillCommonReturnValue returnValue = this.returnValues[j];
                if (!returnValue.getToVariable().equals(variableName)) continue;
                if (log.isDebugEnabled()) {
                    // empty if block
                }
                used = true;
                break;
            }
        }
        return used;
    }

    public void copyValues(SourceContext sourceContext) {
        if (this.returnValues != null && this.returnValues.length > 0) {
            for (int i = 0; i < this.returnValues.length; ++i) {
                this.copyValue(this.returnValues[i], sourceContext);
            }
        }
    }

    protected void copyValue(JRFillCommonReturnValue returnValue, SourceContext sourceContext) {
        try {
            JRFillVariable variable = sourceContext.getToVariable(returnValue.getToVariable());
            Object value = sourceContext.getValue(returnValue);
            if (log.isTraceEnabled()) {
                // empty if block
            }
            Object newValue = returnValue.getIncrementer(sourceContext).increment(variable, value, AbstractValueProvider.getCurrentValueProvider());
            variable.setOldValue(newValue);
            variable.setValue(newValue);
            variable.setIncrementedValue(newValue);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void checkReturnValues(SourceContext sourceContext) throws JRException {
        if (this.returnValues != null && this.returnValues.length > 0) {
            for (int i = 0; i < this.returnValues.length; ++i) {
                JRFillCommonReturnValue returnValue = this.returnValues[i];
                if (returnValue.isDerived()) continue;
                sourceContext.check(returnValue);
            }
        }
    }

    public static interface SourceContext {
        public void check(CommonReturnValue var1) throws JRException;

        public Object getValue(CommonReturnValue var1);

        public JRFillVariable getToVariable(String var1);
    }
}

