/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import net.sf.jasperreports.data.cache.ArrayStore;
import net.sf.jasperreports.data.cache.BufferColumnStore;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.DoubleArrayValues;
import net.sf.jasperreports.data.cache.EmptyColumnValues;
import net.sf.jasperreports.data.cache.RunLengthColumnValues;
import net.sf.jasperreports.data.cache.RunLengthStore;
import net.sf.jasperreports.data.cache.SingleObjectValue;
import net.sf.jasperreports.data.cache.ValueLength;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DoubleArrayStore
implements BufferColumnStore,
ArrayStore {
    private static final Log log = LogFactory.getLog(DoubleArrayStore.class);
    private final double[] values;
    private int count;
    private RunLengthStore runLengthStore;

    public DoubleArrayStore(int size) {
        this.values = new double[size];
        this.runLengthStore = new RunLengthStore(this);
        this.reset();
    }

    private void reset() {
        this.count = 0;
        this.runLengthStore.reset();
    }

    @Override
    public Class<?> getBaseValuesType() {
        return Double.class;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public boolean valuesEqual(int idx1, int idx2) {
        return this.values[idx1] == this.values[idx2];
    }

    @Override
    public void copyValue(int destIdx, int sourceIdx) {
        this.values[destIdx] = this.values[sourceIdx];
    }

    @Override
    public void updateCount(int count) {
        this.count = count;
    }

    @Override
    public void addValue(Object object) {
        double value;
        if (!(object instanceof Double)) {
            throw new IllegalArgumentException();
        }
        this.values[this.count] = value = ((Double)object).doubleValue();
        ++this.count;
        this.runLengthStore.valueAdded();
    }

    @Override
    public boolean full() {
        return this.count >= this.values.length;
    }

    @Override
    public void resetValues() {
        this.reset();
    }

    @Override
    public ColumnValues createValues() {
        if (this.count == 0) {
            if (log.isDebugEnabled()) {
                log.debug(this + ": empty values");
            }
            return EmptyColumnValues.instance();
        }
        if (this.count == 1) {
            if (log.isDebugEnabled()) {
                log.debug(this + ": single value");
            }
            return new SingleObjectValue(this.values[0]);
        }
        int originalCount = this.count;
        ColumnValues runLengthValues = this.runLengthStore.applyRunLengths(ValueLength.FLOAT);
        if (log.isDebugEnabled()) {
            log.debug(this + ": creating values of size " + this.count);
        }
        double[] doubleValues = new double[this.count];
        System.arraycopy(this.values, 0, doubleValues, 0, this.count);
        DoubleArrayValues colValues = new DoubleArrayValues(doubleValues);
        ColumnValues finalValues = runLengthValues == null ? colValues : new RunLengthColumnValues(originalCount, colValues, runLengthValues);
        return finalValues;
    }

    public String toString() {
        return "DoubleArrayStore@" + this.hashCode();
    }
}

