/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.vsf.support;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.apache.http.HttpHost;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttribute;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MTaxCategory;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.spin.model.MADAppRegistration;
import org.spin.model.MADAttachmentReference;
import org.spin.model.MWCategory;
import org.spin.queue.store.support.IECommerce;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.queue.store.util.IECommerceImporter;
import org.spin.store.vsf.support.Attribute;
import org.spin.store.vsf.support.Category;
import org.spin.store.vsf.support.IVueStoreFrontEntity;
import org.spin.store.vsf.support.Product;
import org.spin.store.vsf.support.TaxCategory;
import org.spin.util.support.IAppSupport;

public class VueStoreFrontApi
implements IECommerce,
IAppSupport {
    private String host = "localhost";
    private int port = 9200;
    private String schema = "http";
    private RestHighLevelClient client;
    private static CLogger log = CLogger.getCLogger(VueStoreFrontApi.class);
    public static final String DATE_FORMAT = "yyyy-MM-dd hh:mm:ss";
    private int registrationId = 0;
    private final String SCHEMA_KEY = "schema";

    public static String convertedDate(long millis) {
        return new SimpleDateFormat(DATE_FORMAT).format(millis);
    }

    private void validate() {
        if (this.getAppRegistrationId() <= 0) {
            throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@");
        }
        MADAppRegistration registration = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getAppRegistrationId(), null);
        this.withHost(registration.getHost());
        this.withPort(registration.getPort());
        this.withSchema(registration.getParameterValue("schema"));
        if (Util.isEmpty((String)this.getHost())) {
            throw new AdempiereException("@Host@ @NotFound@");
        }
        if (Util.isEmpty((String)this.getSchema())) {
            throw new AdempiereException("@Schema@ @NotFound@");
        }
        if (this.port <= 0) {
            throw new AdempiereException("@Port@ @NotFound@");
        }
    }

    public VueStoreFrontApi connect() throws IOException {
        if (this.client != null) {
            return this;
        }
        this.validate();
        this.client = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.host, this.port, this.schema)}));
        return this;
    }

    public VueStoreFrontApi close() throws IOException {
        if (this.client == null) {
            return this;
        }
        this.client.close();
        this.client = null;
        return this;
    }

    public final String getHost() {
        return this.host;
    }

    public final VueStoreFrontApi withHost(String host) {
        this.host = host;
        return this;
    }

    public final int getPort() {
        return this.port;
    }

    public final VueStoreFrontApi withPort(int port) {
        this.port = port;
        return this;
    }

    public final String getSchema() {
        return this.schema;
    }

    public final VueStoreFrontApi withSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public VueStoreFrontApi create(IECommerceEntity entity) throws IOException {
        if (Optional.ofNullable(entity).isPresent() && entity.isValid()) {
            if (this.exist(entity)) {
                return this.update(entity);
            }
            IVueStoreFrontEntity vueStoreFrontEntity = (IVueStoreFrontEntity)entity;
            try {
                GetIndexRequest getRequest = new GetIndexRequest(new String[]{vueStoreFrontEntity.getCatalogName()});
                if (!this.client.indices().exists(getRequest, RequestOptions.DEFAULT)) {
                    CreateIndexRequest indexDefinition = new CreateIndexRequest(vueStoreFrontEntity.getCatalogName());
                    Map<String, Object> mapping = vueStoreFrontEntity.getMapping();
                    if (Optional.ofNullable(mapping).isPresent()) {
                        indexDefinition.mapping(mapping);
                        this.client.indices().create(indexDefinition, RequestOptions.DEFAULT);
                    }
                }
            }
            catch (Exception e) {
                throw new AdempiereException((Throwable)e);
            }
            IndexRequest indexRequest = new IndexRequest(vueStoreFrontEntity.getCatalogName()).id(vueStoreFrontEntity.getKeyValue()).source(vueStoreFrontEntity.getMap());
            indexRequest.opType(DocWriteRequest.OpType.CREATE);
            IndexResponse indexResponse = this.client.index(indexRequest, RequestOptions.DEFAULT);
            if (indexResponse.getResult() == DocWriteResponse.Result.CREATED) {
                log.fine("Entity Created: " + vueStoreFrontEntity.getKeyValue());
            } else if (indexResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                log.fine("Entity Updated: " + vueStoreFrontEntity.getKeyValue());
            }
            ReplicationResponse.ShardInfo shardInfo = indexResponse.getShardInfo();
            if (shardInfo.getTotal() != shardInfo.getSuccessful()) {
                log.fine("Entity Created: " + vueStoreFrontEntity.getKeyValue());
            }
            if (shardInfo.getFailed() > 0) {
                for (ReplicationResponse.ShardInfo.Failure failure : shardInfo.getFailures()) {
                    String reason = failure.reason();
                    log.warning("Entity Index Error: " + vueStoreFrontEntity.getKeyValue() + " - Reason: " + reason);
                }
            }
        }
        return this;
    }

    public VueStoreFrontApi update(IECommerceEntity entity) throws IOException {
        if (Optional.ofNullable(entity).isPresent() && entity.isValid()) {
            if (!this.exist(entity)) {
                return this.create(entity);
            }
            this.delete(entity);
            return this.create(entity);
        }
        return this;
    }

    public VueStoreFrontApi delete(IECommerceEntity entity) throws IOException {
        if (Optional.ofNullable(entity).isPresent() && entity.isValid() && this.exist(entity)) {
            IVueStoreFrontEntity vueStoreFrontEntity = (IVueStoreFrontEntity)entity;
            DeleteRequest request = new DeleteRequest(vueStoreFrontEntity.getCatalogName(), vueStoreFrontEntity.getKeyValue());
            DeleteResponse deleteResponse = this.client.delete(request, RequestOptions.DEFAULT);
            ReplicationResponse.ShardInfo shardInfo = deleteResponse.getShardInfo();
            if (shardInfo.getTotal() != shardInfo.getSuccessful()) {
                log.fine("Entity Deleted: " + vueStoreFrontEntity.getKeyValue());
            }
            if (shardInfo.getFailed() > 0) {
                for (ReplicationResponse.ShardInfo.Failure failure : shardInfo.getFailures()) {
                    String reason = failure.reason();
                    log.warning("Entity Delete Error: " + vueStoreFrontEntity.getKeyValue() + " - Reason: " + reason);
                }
            }
        }
        return this;
    }

    public boolean exist(IECommerceEntity entity) throws IOException {
        if (Optional.ofNullable(entity).isPresent() && entity.isValid()) {
            IVueStoreFrontEntity vueStoreFrontEntity = (IVueStoreFrontEntity)entity;
            GetRequest getRequest = new GetRequest(vueStoreFrontEntity.getCatalogName(), vueStoreFrontEntity.getKeyValue());
            getRequest.fetchSourceContext(new FetchSourceContext(false));
            getRequest.storedFields(new String[]{"_none_"});
            return this.client.exists(getRequest, RequestOptions.DEFAULT);
        }
        return false;
    }

    public String testConnection() {
        return "Ok";
    }

    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
    }

    public int getAppRegistrationId() {
        return this.registrationId;
    }

    public int getApiId() {
        return this.getAppRegistrationId();
    }

    public IECommerceEntity getPersistenceWrapper(PO entity) {
        MAttachment attachment;
        MADAttachmentReference attachmentReference;
        if (entity == null) {
            return null;
        }
        IVueStoreFrontEntity wrapper = null;
        if (entity.get_TableName().equals("M_Product")) {
            wrapper = Product.newInstance().withProduct((MProduct)entity);
        } else if (entity.get_TableName().equals("M_Attribute")) {
            wrapper = Attribute.newInstance().withAttribute((MAttribute)entity);
        } else if (entity.get_TableName().equals("C_TaxCategory")) {
            wrapper = TaxCategory.newInstance().withTaxCategory((MTaxCategory)entity);
        } else if (entity.get_TableName().equals("M_ProductPrice")) {
            MProductPrice productPrice = (MProductPrice)entity;
            wrapper = Product.newInstance().withProduct((MProduct)productPrice.getM_Product());
        } else if (entity.get_TableName().equals("W_Category")) {
            wrapper = Category.newInstance().withCategoy((MWCategory)entity);
        } else if (entity.get_TableName().equals("AD_AttachmentReference") && (attachmentReference = (MADAttachmentReference)entity).getAD_Attachment_ID() > 0 && (attachment = (MAttachment)attachmentReference.getAD_Attachment()).getAD_Table_ID() == MProduct.Table_ID && attachment.getRecord_ID() > 0) {
            MProduct product = new MProduct(entity.getCtx(), attachment.getRecord_ID(), entity.get_TrxName());
            wrapper = Product.newInstance().withProduct(product);
        }
        if (wrapper != null) {
            wrapper.withApi(this);
        }
        return wrapper;
    }

    public IECommerceImporter getImporter(String tableName) {
        return null;
    }
}

