/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.vsf.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.MCountry;
import org.compiere.model.MPriceList;
import org.compiere.model.MStore;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.spin.queue.store.event.ECommerceEventListener;
import org.spin.queue.store.support.IECommerce;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.queue.store.util.FindCriteria;
import org.spin.store.vsf.support.IVueStoreFrontEntity;
import org.spin.store.vsf.support.VueStoreFrontApi;

public class TaxCategory
implements IECommerceEntity,
IVueStoreFrontEntity {
    Map<String, Object> map = new HashMap<String, Object>();
    private MTaxCategory taxCategory;
    private List<MTax> taxes;
    private MStore webStore;

    public static TaxCategory newInstance() {
        return new TaxCategory();
    }

    public TaxCategory withTaxCategory(MTaxCategory taxCategory) {
        this.taxCategory = taxCategory;
        return this;
    }

    private TaxCategory() {
    }

    @Override
    public Map<String, Object> getMap() {
        this.loadTaxes();
        this.map = new HashMap<String, Object>();
        this.map.put("id", this.taxCategory.getC_TaxCategory_ID());
        this.map.put("code", this.taxCategory.getName());
        this.map.put("label", this.taxCategory.getName());
        ArrayList taxesIds = new ArrayList();
        ArrayList taxesList = new ArrayList();
        this.taxes.forEach(tax -> {
            HashMap<String, Object> taxMap = new HashMap<String, Object>();
            taxMap.put("id", tax.getC_Tax_ID());
            taxMap.put("code", tax.getTaxIndicator());
            taxMap.put("rate", tax.getRate().doubleValue());
            taxMap.put("tax_postcode", "*");
            if (tax.getC_Country_ID() != 0) {
                taxMap.put("tax_country_id", MCountry.get((Properties)this.taxCategory.getCtx(), (int)tax.getC_Country_ID()).getCountryCode());
            }
            taxesList.add(taxMap);
            taxesIds.add(tax.getC_Tax_ID());
        });
        MPriceList priceList = MPriceList.get((Properties)this.taxCategory.getCtx(), (int)this.webStore.getM_PriceList_ID(), (String)this.taxCategory.get_TrxName());
        this.map.put("calculate_subtotal", priceList.isTaxIncluded());
        this.map.put("tax_rate_ids", taxesIds);
        this.map.put("rates", taxesList);
        this.map.put("is_active", this.taxCategory.isActive());
        this.map.put("created_at", VueStoreFrontApi.convertedDate(this.taxCategory.getCreated().getTime()));
        this.map.put("updated_at", VueStoreFrontApi.convertedDate(this.taxCategory.getUpdated().getTime()));
        return this.map;
    }

    private void loadTaxes() {
        if (this.taxes == null) {
            this.taxes = Arrays.asList(MTax.getAll((Properties)this.taxCategory.getCtx())).stream().filter(tax -> tax.getC_TaxCategory_ID() == this.taxCategory.getC_TaxCategory_ID()).filter(tax -> tax.isSalesTax() || tax.getSOPOType().equals("S") || tax.getSOPOType().equals("B")).collect(Collectors.toList());
        }
    }

    public boolean isValid() {
        this.loadTaxes();
        return this.taxes != null && this.taxes.size() > 0;
    }

    @Override
    public String getKeyValue() {
        if (this.taxCategory == null) {
            return "";
        }
        return String.valueOf(this.taxCategory.get_ID());
    }

    @Override
    public String getCatalogName() {
        return (this.webStore.getWebContext() + "_taxrule").trim().toLowerCase().replaceAll("[+^:,.&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()/]", "");
    }

    public IECommerceEntity withWebStoreId(int webStoreId) {
        if (webStoreId > 0) {
            this.webStore = MStore.get((Properties)this.taxCategory.getCtx(), (int)webStoreId);
        }
        return this;
    }

    @Override
    public Map<String, Object> getMapping() {
        return null;
    }

    public String getIdentifier() {
        return null;
    }

    public Object getValue(String key) {
        return null;
    }

    public void setValue(String key, Object value) {
    }

    public Map<String, Object> getAllValues() {
        return null;
    }

    public IECommerceEntity withApi(IECommerce api) {
        return null;
    }

    public IECommerceEntity create() {
        return null;
    }

    public IECommerceEntity update() {
        return null;
    }

    public IECommerceEntity delete() {
        return null;
    }

    public IECommerceEntity find(FindCriteria criteria) {
        return null;
    }

    public IECommerceEntity withListener(ECommerceEventListener listener) {
        return null;
    }
}

