/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.vsf.support;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MClientInfo;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MStorage;
import org.compiere.model.MStore;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.eevolution.model.MPPProductBOM;
import org.spin.model.MADAttachmentReference;
import org.spin.model.MWCategory;
import org.spin.queue.store.event.ECommerceEventListener;
import org.spin.queue.store.support.IECommerce;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.queue.store.util.FindCriteria;
import org.spin.store.vsf.support.Category;
import org.spin.store.vsf.support.IVueStoreFrontEntity;
import org.spin.store.vsf.support.VueStoreFrontApi;

public class Product
implements IECommerceEntity,
IVueStoreFrontEntity {
    Map<String, Object> map = new HashMap<String, Object>();
    private MProduct product;
    private MStore webStore;

    public static Product newInstance() {
        return new Product();
    }

    public Product withProduct(MProduct product) {
        this.product = product;
        return this;
    }

    private Product() {
    }

    private Map<String, Object> getConversion(MUOM baseUOM, MUOMConversion conversion, BigDecimal price, BigDecimal quantity) {
        HashMap<String, Object> conversionMap = new HashMap<String, Object>();
        BigDecimal multiplyRate = Env.ONE;
        BigDecimal divideRate = Env.ONE;
        if (conversion != null) {
            multiplyRate = conversion.getMultiplyRate();
            divideRate = conversion.getDivideRate();
            baseUOM = MUOM.get((Properties)conversion.getCtx(), (int)conversion.getC_UOM_To_ID());
        }
        conversionMap.put("uom_symbol", baseUOM.getUOMSymbol());
        conversionMap.put("uom_code", baseUOM.getX12DE355());
        conversionMap.put("uom_name", baseUOM.get_Translation("Name"));
        conversionMap.put("qty", quantity.multiply(multiplyRate).setScale(baseUOM.getStdPrecision(), 4).doubleValue());
        if (multiplyRate.compareTo(Env.ONE) >= 0) {
            conversionMap.put("price", price.multiply(multiplyRate).setScale(baseUOM.getStdPrecision(), 4).doubleValue());
        } else {
            conversionMap.put("price", price.multiply(divideRate).setScale(baseUOM.getStdPrecision(), 4).doubleValue());
        }
        conversionMap.put("multiply_rate", multiplyRate.doubleValue());
        conversionMap.put("divide_rate", divideRate.doubleValue());
        return conversionMap;
    }

    private void fillPrice(MPriceList priceList, MProduct product, MProductPricing productPricing, Map<String, Object> mapForPut) {
        BigDecimal price = productPricing.getPriceStd().setScale(productPricing.getPrecision());
        BigDecimal stock = this.getStock(product);
        int defaultSalesUOMId = product.get_ValueAsInt("DefaultSalesUOM_ID");
        MUOM baseUOM = MUOM.get((Properties)product.getCtx(), (int)product.getC_UOM_ID());
        mapForPut.put("base_uom", this.getConversion(baseUOM, null, price, stock));
        mapForPut.put("sales_uom", this.getConversion(baseUOM, null, price, stock));
        AtomicReference<BigDecimal> multiplier = new AtomicReference<BigDecimal>(Env.ONE);
        AtomicReference<BigDecimal> divide = new AtomicReference<BigDecimal>(Env.ONE);
        AtomicInteger precision = new AtomicInteger(2);
        AtomicReference<BigDecimal> priceToConvert = new AtomicReference<BigDecimal>(price);
        AtomicReference<BigDecimal> stockToConvert = new AtomicReference<BigDecimal>(stock);
        HashMap conversionsMap = new HashMap();
        Arrays.asList(MUOMConversion.getProductConversions((Properties)product.getCtx(), (int)product.getM_Product_ID())).forEach(conversion -> {
            MUOM uomTo = MUOM.get((Properties)product.getCtx(), (int)conversion.getC_UOM_To_ID());
            int conversionPresicion = uomTo.getStdPrecision();
            if (defaultSalesUOMId == conversion.getC_UOM_To_ID()) {
                multiplier.set(conversion.getMultiplyRate());
                divide.set(conversion.getDivideRate());
                precision.set(conversionPresicion);
                mapForPut.put("sales_uom", this.getConversion(uomTo, (MUOMConversion)conversion, (BigDecimal)priceToConvert.get(), (BigDecimal)stockToConvert.get()));
            }
            conversionsMap.put(uomTo.getX12DE355(), this.getConversion(baseUOM, (MUOMConversion)conversion, (BigDecimal)priceToConvert.get(), (BigDecimal)stockToConvert.get()));
        });
        if (conversionsMap.size() > 0) {
            mapForPut.put("conversions", conversionsMap);
        }
        if (defaultSalesUOMId > 0 && multiplier.get() != null) {
            price = multiplier.get().compareTo(Env.ONE) >= 0 ? price.multiply(multiplier.get()).setScale(precision.get(), 4) : price.multiply(divide.get()).setScale(precision.get(), 4);
            stock = stock.multiply(multiplier.get()).setScale(precision.get(), 4);
        }
        HashMap<String, Comparable<Boolean>> stockMap = new HashMap<String, Comparable<Boolean>>();
        stockMap.put("is_in_stock", Boolean.valueOf(product.isStocked()));
        stockMap.put("qty", Double.valueOf(stock.doubleValue()));
        this.map.put("stock", stockMap);
        this.map.put("price", price.doubleValue());
        if (this.webStore.get_ValueAsBoolean("IsStoreShowConvertedAmount") && this.webStore.get_ValueAsInt("StoreDisplayCurrency_ID") > 0 && price.compareTo(Env.ZERO) > 0) {
            int displayCurrencyId = this.webStore.get_ValueAsInt("StoreDisplayCurrency_ID");
            int conversionTypeId = this.webStore.get_ValueAsInt("StoreConversionType_ID");
            int conversionRateId = MConversionRate.getConversionRateId((int)priceList.getC_Currency_ID(), (int)displayCurrencyId, (Timestamp)productPricing.getPriceDate(), (int)conversionTypeId, (int)this.webStore.getAD_Client_ID(), (int)this.webStore.getAD_Org_ID());
            if (conversionRateId > 0) {
                MConversionRate conversionRate = MConversionRate.get((Properties)priceList.getCtx(), (int)conversionRateId);
                BigDecimal conversionRateValue = Optional.ofNullable(conversionRate.getMultiplyRate()).orElse(Env.ZERO);
                MCurrency displayCurrency = MCurrency.get((Properties)Env.getCtx(), (int)displayCurrencyId);
                BigDecimal convertedPrice = Optional.ofNullable(productPricing.getPriceList()).orElse(Env.ZERO).multiply(conversionRateValue, MathContext.DECIMAL128).setScale(displayCurrency.getStdPrecision(), 4);
                this.map.put("display_price", convertedPrice.doubleValue());
                this.map.put("display_currency_code", displayCurrency.getISO_Code());
                this.map.put("display_currency_symbol", displayCurrency.getCurSymbol());
                this.map.put("display_currency_description", displayCurrency.getDescription());
                this.map.put("display_conversion_rate", conversionRateValue.doubleValue());
                this.map.put("display_conversion_type_id", conversionRate.getC_ConversionType_ID());
                this.map.put("display_conversion_type_name", conversionRate.getC_ConversionType().getName());
            }
        }
    }

    @Override
    public Map<String, Object> getMap() {
        this.map = new HashMap<String, Object>();
        if (Optional.ofNullable(this.product).isPresent()) {
            this.map.put("id", this.product.getM_Product_ID());
            this.map.put("name", this.product.getName());
            this.map.put("image", this.getImageName(this.product));
            this.map.put("sku", this.product.getSKU());
            this.map.put("url_key", this.getValidValue(this.product.getName()));
            this.map.put("type_id", this.getProductTypeFromProduct(this.product));
            this.map.put("short_description", this.product.getDescription());
            this.map.put("description", this.product.getHelp());
            this.map.put("status", this.product.isActive() ? "1" : "2");
            this.map.put("visibility", "4");
            this.calculatePrice(this.product, this.map);
            ArrayList categories = new ArrayList();
            ArrayList categoriesIds = new ArrayList();
            List productGroups = MWCategory.getOfProduct((Properties)this.product.getCtx(), (int)this.product.getM_Product_ID(), (String)this.product.get_TrxName());
            StringBuffer urlPath = new StringBuffer();
            if (productGroups != null && productGroups.size() > 0) {
                productGroups.forEach(group -> {
                    Category wrapperOfGroup = Category.newInstance().withCategoy((MWCategory)group);
                    categories.add(wrapperOfGroup.getMap());
                    categoriesIds.add(wrapperOfGroup.getKeyValue());
                    if (urlPath.length() == 0) {
                        urlPath.append(wrapperOfGroup.getURLPath());
                    }
                });
            }
            urlPath.append("/").append(this.getValidValue(this.product.getName() + "-" + this.product.getM_Product_ID())).append(".html");
            this.map.put("slug", this.getValidValue(this.product.getName() + "-" + this.product.getM_Product_ID()));
            this.map.put("url_path", urlPath.toString());
            this.map.put("category_ids", categoriesIds);
            this.map.put("category", categories);
            ArrayList mediaList = new ArrayList();
            MClientInfo clientInfo = MClientInfo.get((Properties)this.product.getCtx());
            if (clientInfo.getFileHandler_ID() != 0) {
                AtomicInteger counter = new AtomicInteger(1);
                Optional.ofNullable(this.product.getAttachment()).ifPresent(attachment -> MADAttachmentReference.getListByAttachmentId((Properties)this.product.getCtx(), (int)clientInfo.getFileHandler_ID(), (int)attachment.getAD_Attachment_ID(), (String)this.product.get_TrxName()).forEach(attachmentReference -> {
                    HashMap<String, Object> mediaMap = new HashMap<String, Object>();
                    mediaMap.put("image", "/" + attachmentReference.getValidFileName());
                    mediaMap.put("pos", counter.getAndIncrement());
                    mediaList.add(mediaMap);
                }));
            }
            this.map.put("media_gallery", mediaList);
            if (this.product.getM_AttributeSet_ID() != 0) {
                ArrayList configurableList = new ArrayList();
                AtomicInteger counter = new AtomicInteger(1);
                MAttributeSet attributeSet = MAttributeSet.get((Properties)this.product.getCtx(), (int)this.product.getM_AttributeSet_ID());
                ArrayList configurableChildren = new ArrayList();
                ArrayList combination = new ArrayList();
                if (attributeSet.isLot()) {
                    String attributeCode = attributeSet.getName().toLowerCase().replaceAll(" ", "");
                    HashMap<String, Object> attributeMap = new HashMap<String, Object>();
                    attributeMap.put("id", attributeSet.getM_AttributeSet_ID());
                    attributeMap.put("attribute_id", attributeSet.getM_AttributeSet_ID());
                    attributeMap.put("label", attributeSet.getName());
                    attributeMap.put("pos", counter.getAndIncrement());
                    ArrayList attributeValuesList = new ArrayList();
                    ArrayList combinationAttributes = new ArrayList();
                    AtomicReference firstAttributeValue = new AtomicReference();
                    ArrayList options = new ArrayList();
                    new Query(this.product.getCtx(), "M_AttributeSetInstance", "M_AttributeSet_ID = ? AND EXISTS(SELECT 1 FROM M_Storage s WHERE s.M_AttributeSetInstance_ID = M_AttributeSetInstance.M_AttributeSetInstance_ID AND s.M_Product_ID = ?)", this.product.get_TrxName()).setParameters(new Object[]{attributeSet.getM_AttributeSet_ID(), this.product.getM_Product_ID()}).setOnlyActiveRecords(true).list().stream().filter(instance -> !Util.isEmpty((String)instance.getLot())).forEach(instance -> {
                        HashMap<String, String> attributeValueMap = new HashMap<String, String>();
                        attributeValueMap.put("value_index", String.valueOf(instance.getM_AttributeSetInstance_ID()));
                        attributeValueMap.put("label", instance.getDescription());
                        attributeValuesList.add(attributeValueMap);
                        options.add(instance.getM_AttributeSetInstance_ID());
                        combinationAttributes.add(new AttributeCombination(instance.getM_AttributeSetInstance_ID(), attributeCode));
                        if (firstAttributeValue.get() == null) {
                            firstAttributeValue.set(instance.getM_AttributeSetInstance_ID());
                        }
                    });
                    combination.add(combinationAttributes);
                    attributeMap.put("values", attributeValuesList);
                    attributeMap.put("product_id", this.product.getM_Product_ID());
                    attributeMap.put("attribute_code", attributeCode);
                    this.map.put(attributeCode + "_options", options);
                    this.map.put(attributeCode, firstAttributeValue.get());
                    configurableList.add(attributeMap);
                }
                Arrays.asList(attributeSet.getMAttributes(true)).forEach(attribute -> {
                    HashMap<String, Object> attributeMap = new HashMap<String, Object>();
                    attributeMap.put("id", attribute.getM_Attribute_ID());
                    attributeMap.put("attribute_id", attribute.getM_Attribute_ID());
                    attributeMap.put("label", attribute.getName());
                    attributeMap.put("pos", counter.getAndIncrement());
                    ArrayList options = new ArrayList();
                    String attributeCode = Optional.ofNullable((String)attribute.get_Value("Value")).orElse(attribute.getName()).toLowerCase().replaceAll(" ", "");
                    if (attribute.getAttributeValueType().equals("L")) {
                        ArrayList attributeValuesList = new ArrayList();
                        ArrayList combinationAttributes = new ArrayList();
                        Arrays.asList(attribute.getMAttributeValues()).forEach(attributeValue -> {
                            HashMap<String, String> attributeValueMap = new HashMap<String, String>();
                            attributeValueMap.put("value_index", String.valueOf(attributeValue.getM_AttributeValue_ID()));
                            attributeValueMap.put("label", attributeValue.getName());
                            attributeValuesList.add(attributeValueMap);
                            options.add(attributeValue.getM_AttributeValue_ID());
                            combinationAttributes.add(new AttributeCombination(attributeValue.getM_AttributeValue_ID(), attributeCode));
                        });
                        combination.add(combinationAttributes);
                        attributeMap.put("values", attributeValuesList);
                    }
                    attributeMap.put("product_id", this.product.getM_Product_ID());
                    attributeMap.put("attribute_code", attributeCode);
                    this.map.put(attributeCode + "_options", options);
                    configurableList.add(attributeMap);
                });
                if (configurableList.size() > 0) {
                    this.map.put("configurable_options", configurableList);
                }
                List<List<List>> combinations = Product.combinations(combination);
                combinations.forEach(listValue -> {
                    HashMap<String, Object> childMap = new HashMap<String, Object>();
                    childMap.put("id", this.product.getM_Product_ID());
                    childMap.put("name", this.product.getName());
                    childMap.put("url_key", this.getValidValue(this.product.getName()));
                    childMap.put("url_path", this.product.getDescriptionURL());
                    childMap.put("status", this.getProductTypeFromProduct(this.product));
                    childMap.put("image", this.getImageName(this.product));
                    childMap.put("type_id", this.getProductTypeFromProduct(this.product));
                    this.calculatePrice(this.product, childMap);
                    configurableChildren.add(childMap);
                    if (listValue.size() == 1) {
                        childMap.put("sku", this.product.getSKU() + ":" + ((AttributeCombination)listValue.get(0)).getId());
                    } else {
                        HashMap searchCriteria = new HashMap();
                        listValue.forEach(combinedAttribute -> {
                            searchCriteria.put(combinedAttribute.getCode(), combinedAttribute.getId());
                            childMap.put(combinedAttribute.getCode(), combinedAttribute.getId());
                        });
                        childMap.put("sku", this.product.getSKU() + ":" + ((Object)searchCriteria).toString());
                    }
                });
                if (configurableChildren.size() > 0) {
                    this.map.put("configurable_children", configurableChildren);
                }
            }
            if (this.product.isBOM() && this.product.isVerified()) {
                this.map.put("configurable_children", this.getBillOfMaterial(this.product));
            }
            this.map.put("is_active", this.product.isActive());
            this.map.put("created_at", VueStoreFrontApi.convertedDate(this.product.getCreated().getTime()));
            this.map.put("updated_at", VueStoreFrontApi.convertedDate(this.product.getUpdated().getTime()));
        }
        return this.map;
    }

    public static <T> List<List<T>> combinations(List<List<T>> lists) {
        if (lists == null) {
            return Collections.emptyList();
        }
        return lists.stream().filter(list -> list != null && list.size() > 0).map(list -> list.stream().map(Collections::singletonList).collect(Collectors.toList())).reduce((list1, list2) -> list1.stream().flatMap(inner1 -> list2.stream().map(inner2 -> Stream.of(inner1, inner2).flatMap(Collection::stream).collect(Collectors.toList()))).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private String getImageName(MProduct product) {
        MClientInfo clientInfo = MClientInfo.get((Properties)product.getCtx());
        AtomicReference imageName = new AtomicReference();
        if (clientInfo.getFileHandler_ID() != 0) {
            Optional.ofNullable(product.getAttachment()).ifPresent(attachment -> {
                Optional maybeReference = MADAttachmentReference.getListByAttachmentId((Properties)product.getCtx(), (int)clientInfo.getFileHandler_ID(), (int)attachment.getAD_Attachment_ID(), (String)product.get_TrxName()).stream().findFirst();
                if (maybeReference.isPresent()) {
                    imageName.set("/" + ((MADAttachmentReference)maybeReference.get()).getValidFileName());
                }
            });
        }
        return (String)imageName.get();
    }

    private List<Map<String, Object>> getBillOfMaterial(MProduct product) {
        ArrayList<Map<String, Object>> bomList = new ArrayList<Map<String, Object>>();
        MPPProductBOM billOfMaterial = MPPProductBOM.getDefault((MProduct)product, (String)product.get_TrxName());
        if (Optional.ofNullable(billOfMaterial).isPresent()) {
            HashMap childMap = new HashMap();
            Arrays.asList(billOfMaterial.getLines()).forEach(child -> {
                MProduct childProduct = MProduct.get((Properties)product.getCtx(), (int)child.getM_Product_ID());
                childMap.put("id", childProduct.getM_Product_ID());
                childMap.put("sku", childProduct.getSKU());
                childMap.put("name", childProduct.getName());
                childMap.put("url_key", this.getValidValue(childProduct.getName()));
                childMap.put("url_path", childProduct.getDescriptionURL());
                childMap.put("status", this.getProductTypeFromProduct(childProduct));
                childMap.put("image", this.getImageName(childProduct));
                childMap.put("type_id", this.getProductTypeFromProduct(childProduct));
                this.calculatePrice(childProduct, childMap);
                bomList.add(childMap);
            });
        }
        return bomList;
    }

    private void calculatePrice(MProduct product, Map<String, Object> mapForPut) {
        MPriceList priceList = MPriceList.get((Properties)product.getCtx(), (int)this.webStore.getM_PriceList_ID(), (String)product.get_TrxName());
        Timestamp validFrom = TimeUtil.getDay((long)System.currentTimeMillis());
        MProductPricing productPricing = new MProductPricing(product.getM_Product_ID(), 0, Env.ZERO, true, product.get_TrxName());
        productPricing.setM_PriceList_ID(priceList.getM_PriceList_ID());
        productPricing.setPriceDate(validFrom);
        this.fillPrice(priceList, product, productPricing, mapForPut);
    }

    private String getValidValue(String value) {
        return value.trim().toLowerCase().replaceAll(" ", "-").replaceAll("[+^:,.&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()/]", "");
    }

    private BigDecimal getStock(MProduct product) {
        Optional<MStorage> maybeStorage = Arrays.asList(MStorage.getOfProduct((Properties)Env.getCtx(), (int)product.getM_Product_ID(), (String)product.get_TrxName())).stream().filter(storage -> storage.getM_Warehouse_ID() == this.webStore.getM_Warehouse_ID()).reduce(StockSummary::add);
        if (maybeStorage.isPresent()) {
            BigDecimal quantityOnHand = Optional.ofNullable(maybeStorage.get().getQtyOnHand()).orElse(Env.ZERO);
            BigDecimal quantityReserved = Optional.ofNullable(maybeStorage.get().getQtyReserved()).orElse(Env.ZERO);
            if (quantityReserved.signum() < 0) {
                return Env.ZERO;
            }
            return quantityOnHand.subtract(quantityReserved);
        }
        return Env.ZERO;
    }

    @Override
    public String getKeyValue() {
        if (this.product == null) {
            return "";
        }
        return String.valueOf(this.product.getM_Product_ID());
    }

    private String getProductTypeFromProduct(MProduct product) {
        if (Util.isEmpty((String)product.getProductType())) {
            return "simple";
        }
        if (product.getProductType().equals("I") && product.isStocked() && product.getM_AttributeSet_ID() > 0) {
            return "configurable";
        }
        if (product.getProductType().equals("I") && product.isStocked() && product.isBOM()) {
            return "grouped";
        }
        if (product.getProductType().equals("S")) {
            return "configurable";
        }
        if (product.getProductType().equals("I") && !product.isStocked() && product.isBOM()) {
            return "grouped";
        }
        if (product.getProductType().equals("S") && product.getM_Product_Category().getA_Asset_Group_ID() > 0) {
            return "downloadable";
        }
        if ((product.getProductType().equals("I") || product.getProductType().equals("S")) && product.getR_MailText_ID() > 0) {
            return "gift";
        }
        return "simple";
    }

    @Override
    public String getCatalogName() {
        return (this.webStore.getWebContext() + "_product").trim().toLowerCase().replaceAll("[+^:,.&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()/]", "");
    }

    public boolean isValid() {
        return this.product != null && this.webStore != null;
    }

    public IECommerceEntity withWebStoreId(int webStoreId) {
        if (webStoreId > 0) {
            this.webStore = MStore.get((Properties)this.product.getCtx(), (int)webStoreId);
        }
        return this;
    }

    @Override
    public Map<String, Object> getMapping() {
        HashMap<String, String> createdAt = new HashMap<String, String>();
        createdAt.put("type", "date");
        createdAt.put("format", "yyyy-MM-dd hh:mm:ss");
        HashMap<String, String> updatedAt = new HashMap<String, String>();
        updatedAt.put("type", "date");
        updatedAt.put("format", "yyyy-MM-dd hh:mm:ss");
        HashMap properties = new HashMap();
        properties.put("created_at", createdAt);
        properties.put("updated_at", updatedAt);
        HashMap<String, String> slug = new HashMap<String, String>();
        slug.put("type", "keyword");
        properties.put("slug", slug);
        HashMap<String, String> urlPath = new HashMap<String, String>();
        urlPath.put("type", "keyword");
        properties.put("url_path", urlPath);
        HashMap<String, String> urlKey = new HashMap<String, String>();
        urlKey.put("type", "keyword");
        properties.put("url_key", urlKey);
        HashMap<String, String> sku = new HashMap<String, String>();
        sku.put("type", "keyword");
        properties.put("sku", sku);
        HashMap<String, String> price = new HashMap<String, String>();
        price.put("type", "float");
        properties.put("price", price);
        HashMap<String, String> finalPrice = new HashMap<String, String>();
        finalPrice.put("type", "float");
        properties.put("final_price", finalPrice);
        HashMap<String, String> sizeOptions = new HashMap<String, String>();
        sizeOptions.put("type", "integer");
        properties.put("size_options", sizeOptions);
        properties.put("display_price", price);
        properties.put("display_conversion_rate", price);
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put("properties", properties);
        return mapping;
    }

    public String getIdentifier() {
        return null;
    }

    public Object getValue(String key) {
        return null;
    }

    public void setValue(String key, Object value) {
    }

    public Map<String, Object> getAllValues() {
        return null;
    }

    public IECommerceEntity withApi(IECommerce api) {
        return null;
    }

    public IECommerceEntity create() {
        return null;
    }

    public IECommerceEntity update() {
        return null;
    }

    public IECommerceEntity delete() {
        return null;
    }

    public IECommerceEntity find(FindCriteria criteria) {
        return null;
    }

    public IECommerceEntity withListener(ECommerceEventListener listener) {
        return null;
    }

    private static final class StockSummary {
        private StockSummary() {
        }

        public static MStorage add(MStorage previousValue, MStorage newValue) {
            previousValue.setQtyOnHand(previousValue.getQtyOnHand().add(newValue.getQtyOnHand()));
            previousValue.setQtyReserved(previousValue.getQtyReserved().add(newValue.getQtyReserved()));
            return previousValue;
        }
    }

    private class AttributeCombination {
        private int id;
        private String code;

        public AttributeCombination(int id, String code) {
            this.id = id;
            this.code = code;
        }

        public final int getId() {
            return this.id;
        }

        public final String getCode() {
            return this.code;
        }
    }
}

