/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.vsf.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeValue;
import org.compiere.model.MStore;
import org.spin.queue.store.event.ECommerceEventListener;
import org.spin.queue.store.support.IECommerce;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.queue.store.util.FindCriteria;
import org.spin.store.vsf.support.IVueStoreFrontEntity;
import org.spin.store.vsf.support.VueStoreFrontApi;

public class Attribute
implements IECommerceEntity,
IVueStoreFrontEntity {
    Map<String, Object> map = new HashMap<String, Object>();
    private MAttribute attribute;
    private List<MAttributeValue> attributeValues;
    private MStore webStore;

    public static Attribute newInstance() {
        return new Attribute();
    }

    public Attribute withAttribute(MAttribute attribute) {
        this.attribute = attribute;
        return this;
    }

    private Attribute() {
    }

    @Override
    public Map<String, Object> getMap() {
        this.map = new HashMap<String, Object>();
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        this.map.put("id", this.attribute.getM_Attribute_ID());
        this.map.put("is_user_defined", true);
        this.map.put("is_visible", true);
        this.map.put("attribute_code", this.getValidValue(this.attribute.getName()));
        this.map.put("default_frontend_label", this.attribute.getName());
        if (this.attribute.getAttributeValueType().equals("L")) {
            ArrayList attributeValuesList = new ArrayList();
            Arrays.asList(this.attribute.getMAttributeValues()).stream().filter(attributeValue -> Optional.ofNullable(attributeValue).isPresent()).forEach(attributeValue -> {
                HashMap<String, String> attributeValueMap = new HashMap<String, String>();
                attributeValueMap.put("value", String.valueOf(attributeValue.getM_AttributeValue_ID()));
                attributeValueMap.put("label", attributeValue.getName());
                attributeValuesList.add(attributeValueMap);
            });
            if (attributeValuesList.size() == 2) {
                attributeMap.put("frontend_input", "boolean");
            } else {
                attributeMap.put("frontend_input", "select");
            }
            this.map.put("options", attributeValuesList);
        }
        this.map.put("is_active", this.attribute.isActive());
        this.map.put("created_at", VueStoreFrontApi.convertedDate(this.attribute.getCreated().getTime()));
        this.map.put("updated_at", VueStoreFrontApi.convertedDate(this.attribute.getUpdated().getTime()));
        return this.map;
    }

    private String getValidValue(String value) {
        return value.trim().toLowerCase().replaceAll(" ", "-").replaceAll("[+^:,.&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()/]", "");
    }

    @Override
    public String getKeyValue() {
        if (this.attribute == null) {
            return "";
        }
        return String.valueOf(this.attribute.get_ID());
    }

    @Override
    public String getCatalogName() {
        return (this.webStore.getWebContext() + "_attribute").trim().toLowerCase().replaceAll("[+^:,.&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()/]", "");
    }

    public boolean isValid() {
        if (this.attribute == null) {
            return false;
        }
        if (!this.attribute.getAttributeValueType().equals("L")) {
            return false;
        }
        if (this.attributeValues == null && this.attribute.getMAttributeValues() != null && this.attribute.getMAttributeValues().length > (this.attribute.isMandatory() ? 0 : 1)) {
            this.attributeValues = Arrays.asList(this.attribute.getMAttributeValues());
        }
        return this.attributeValues != null && this.attributeValues.size() > 0;
    }

    public IECommerceEntity withWebStoreId(int webStoreId) {
        if (webStoreId > 0) {
            this.webStore = MStore.get((Properties)this.attribute.getCtx(), (int)webStoreId);
        }
        return this;
    }

    @Override
    public Map<String, Object> getMapping() {
        return null;
    }

    public String getIdentifier() {
        return null;
    }

    public Object getValue(String key) {
        return null;
    }

    public void setValue(String key, Object value) {
    }

    public Map<String, Object> getAllValues() {
        return null;
    }

    public IECommerceEntity withApi(IECommerce api) {
        return null;
    }

    public IECommerceEntity create() {
        return null;
    }

    public IECommerceEntity update() {
        return null;
    }

    public IECommerceEntity delete() {
        return null;
    }

    public IECommerceEntity find(FindCriteria criteria) {
        return null;
    }

    public IECommerceEntity withListener(ECommerceEventListener listener) {
        return null;
    }
}

