/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.store.util;

import java.util.ArrayList;
import java.util.List;

public class FindCondition {
    private String key;
    private OPERATORS operator;
    private List<Object> values = new ArrayList<Object>();

    public static FindCondition newInstance() {
        return new FindCondition();
    }

    private FindCondition() {
    }

    public final String getKey() {
        return this.key;
    }

    public final FindCondition withKey(String key) {
        this.key = key;
        return this;
    }

    public final OPERATORS getOperator() {
        return this.operator;
    }

    public final FindCondition withOperator(OPERATORS operator) {
        this.operator = operator;
        return this;
    }

    public final Object getValue() {
        if (this.values.size() > 0) {
            return this.values.get(0);
        }
        return null;
    }

    public final FindCondition withValue(Object value) {
        this.values = new ArrayList<Object>();
        this.values.add(value);
        return this;
    }

    public final List<Object> getValues() {
        return this.values;
    }

    public final FindCondition withValues(List<Object> values) {
        this.values = values;
        return this;
    }

    public final FindCondition addValue(Object value) {
        this.values.add(value);
        return this;
    }

    public static enum OPERATORS {
        EQUAL,
        NOT_EQUAL,
        LIKE,
        NOT_LIKE,
        GREATER,
        GREATER_EQUAL,
        LESS,
        LESS_EQUAL,
        BETWEEN,
        NOT_NULL,
        NULL,
        IN,
        NOT_IN;

    }
}

