/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.store.setup;

import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProcess;
import org.compiere.model.MScheduler;
import org.compiere.model.MSchedulerPara;
import org.compiere.model.Query;
import org.compiere.model.X_AD_ModelValidator;
import org.compiere.util.TimeUtil;
import org.spin.queue.model.MADQueueType;
import org.spin.queue.process.FlushSystemQueue;
import org.spin.queue.store.model.validator.ECommercePersistence;
import org.spin.util.ISetupDefinition;

public class ECommerceSetup
implements ISetupDefinition {
    private static final String DESCRIPTION = "(*Created from Setup Automatically*)";
    private static final String UUID = "(*AutomaticSetup*)";
    private static final String NAME = "e-Commerce Queue Manager";
    private static final String ENTITY_TYPE = "ECA35";
    private static final int DEFAULT_SEQUENCE = 250;
    private static final String QUEUE_TYPE = "ECC";

    public String doIt(Properties context, String transactionName) {
        this.createModelValidator(context, transactionName);
        this.createSchedule(context, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private void createSchedule(Properties context, String transactionName) {
        MADQueueType queueType = MADQueueType.getByQueueType((Properties)context, (String)QUEUE_TYPE, (String)transactionName);
        if (queueType == null) {
            throw new AdempiereException("@AD_QueueType_ID@ @NotFound@");
        }
        new Query(context, "AD_Scheduler", "AD_Process_ID = ? AND EXISTS(SELECT 1 FROM AD_Scheduler_Para sp INNER JOIN AD_Process_Para pp ON(pp.AD_Process_Para_ID = sp.AD_Process_Para_ID) WHERE sp.AD_Scheduler_ID = AD_Scheduler.AD_Scheduler_ID AND pp.ColumnName = ? AND sp.ParameterDefault = ?)", transactionName).setParameters(new Object[]{FlushSystemQueue.getProcessId(), "AD_QueueType_ID", String.valueOf(queueType.getAD_QueueType_ID())}).setClient_ID().list().forEach(scheduler -> scheduler.deleteEx(true));
        MScheduler scheduler2 = new MScheduler(context, 0, transactionName);
        scheduler2.setAD_Org_ID(0);
        scheduler2.setName(FlushSystemQueue.getProcessName() + ": Store");
        scheduler2.setDescription(DESCRIPTION);
        scheduler2.setAD_Process_ID(FlushSystemQueue.getProcessId());
        scheduler2.setSupervisor_ID(100);
        scheduler2.setFrequencyType("M");
        scheduler2.setFrequency(2);
        scheduler2.setKeepLogDays(7);
        scheduler2.setDateNextRun(TimeUtil.addMinutess((Timestamp)TimeUtil.getDay((long)System.currentTimeMillis()), (int)scheduler2.getFrequency()));
        scheduler2.saveEx();
        MProcess process = MProcess.get((Properties)context, (int)FlushSystemQueue.getProcessId());
        process.getParametersAsList().stream().filter(parameter -> parameter.getColumnName().equals("BatchsToProcess")).findFirst().ifPresent(parameter -> {
            MSchedulerPara schedulerParameter = new MSchedulerPara(context, 0, transactionName);
            schedulerParameter.setAD_Org_ID(0);
            schedulerParameter.setAD_Scheduler_ID(scheduler2.getAD_Scheduler_ID());
            schedulerParameter.setAD_Process_Para_ID(parameter.getAD_Process_Para_ID());
            schedulerParameter.setParameterDefault("10");
            schedulerParameter.saveEx();
        });
        process.getParametersAsList().stream().filter(parameter -> parameter.getColumnName().equals("RecordsByBatch")).findFirst().ifPresent(parameter -> {
            MSchedulerPara schedulerParameter = new MSchedulerPara(context, 0, transactionName);
            schedulerParameter.setAD_Org_ID(0);
            schedulerParameter.setAD_Scheduler_ID(scheduler2.getAD_Scheduler_ID());
            schedulerParameter.setAD_Process_Para_ID(parameter.getAD_Process_Para_ID());
            schedulerParameter.setParameterDefault("100");
            schedulerParameter.saveEx();
        });
        process.getParametersAsList().stream().filter(parameter -> parameter.getColumnName().equals("IsDeleteAfterProcess")).findFirst().ifPresent(parameter -> {
            MSchedulerPara schedulerParameter = new MSchedulerPara(context, 0, transactionName);
            schedulerParameter.setAD_Org_ID(0);
            schedulerParameter.setAD_Scheduler_ID(scheduler2.getAD_Scheduler_ID());
            schedulerParameter.setAD_Process_Para_ID(parameter.getAD_Process_Para_ID());
            schedulerParameter.setParameterDefault("N");
            schedulerParameter.saveEx();
        });
        process.getParametersAsList().stream().filter(parameter -> parameter.getColumnName().equals("AD_QueueType_ID")).findFirst().ifPresent(parameter -> {
            MSchedulerPara schedulerParameter = new MSchedulerPara(context, 0, transactionName);
            schedulerParameter.setAD_Org_ID(0);
            schedulerParameter.setAD_Scheduler_ID(scheduler2.getAD_Scheduler_ID());
            schedulerParameter.setAD_Process_Para_ID(parameter.getAD_Process_Para_ID());
            schedulerParameter.setParameterDefault(String.valueOf(queueType.getAD_QueueType_ID()));
            schedulerParameter.saveEx();
        });
    }

    private X_AD_ModelValidator createModelValidator(Properties context, String transactionName) {
        X_AD_ModelValidator modelValidator = (X_AD_ModelValidator)new Query(context, "AD_ModelValidator", "ModelValidationClass = ?", transactionName).setParameters(new Object[]{ECommercePersistence.class.getName()}).setClient_ID().first();
        if (modelValidator != null && modelValidator.getAD_ModelValidator_ID() > 0) {
            return modelValidator;
        }
        modelValidator = new X_AD_ModelValidator(context, 0, transactionName);
        modelValidator.setName(NAME);
        modelValidator.setEntityType(ENTITY_TYPE);
        modelValidator.setDescription(DESCRIPTION);
        modelValidator.setSeqNo(250);
        modelValidator.setModelValidationClass(ECommercePersistence.class.getName());
        modelValidator.setUUID(UUID);
        modelValidator.setIsDirectLoad(true);
        modelValidator.saveEx();
        return modelValidator;
    }
}

