/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.store.process;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MAttachment;
import org.compiere.model.MProduct;
import org.spin.queue.store.process.PublishOnECommerceAbstract;

public class PublishOnECommerce
extends PublishOnECommerceAbstract {
    private AtomicInteger counter = new AtomicInteger();

    protected String doIt() throws Exception {
        if (this.getRecord_ID() > 0) {
            this.publishProduct(this.getRecord_ID());
        } else {
            List productsIds = this.getSelectionKeys();
            if (productsIds != null) {
                productsIds.forEach(productId -> this.publishProduct((int)productId));
            }
        }
        return "@ECA35.ProductsPublished@: " + this.counter.get();
    }

    private void publishProduct(int productId) {
        StringBuffer errorMessage = new StringBuffer();
        MProduct product = new MProduct(this.getCtx(), productId, this.get_TrxName());
        MAttachment attachment = product.getAttachment();
        if (attachment == null || attachment.getAD_Attachment_ID() <= 0) {
            errorMessage.append("@AD_Attachment_ID@ @NotFound@");
        }
        if (errorMessage.length() > 0) {
            this.addLog(errorMessage.toString());
        } else {
            product.setIsWebStoreFeatured(true);
            product.saveEx();
            this.counter.getAndIncrement();
        }
    }
}

