/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.store.process;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MStore;
import org.spin.model.MADAppRegistration;
import org.spin.queue.store.process.ImportDataFromECommerceAbstract;
import org.spin.queue.store.support.IECommerce;
import org.spin.queue.store.util.IECommerceImporter;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;

public class ImportDataFromECommerce
extends ImportDataFromECommerceAbstract {
    protected String doIt() throws Exception {
        if (this.getStoreId() == 0) {
            throw new AdempiereException("@W_Store_ID@ @NotFound@");
        }
        MStore webStore = MStore.get((Properties)this.getCtx(), (int)this.getStoreId());
        if (webStore.get_ValueAsInt("CacheServerProvider_ID") <= 0) {
            throw new AdempiereException("@CacheServerProvider_ID@ @NotFound@");
        }
        MADAppRegistration registeredApplication = MADAppRegistration.getById((Properties)this.getCtx(), (int)webStore.get_ValueAsInt("CacheServerProvider_ID"), (String)this.get_TrxName());
        IAppSupport supportedApplication = AppSupportHandler.getInstance().getAppSupport(registeredApplication);
        if (supportedApplication != null && IECommerce.class.isAssignableFrom(supportedApplication.getClass())) {
            IECommerce ecommerce = (IECommerce)supportedApplication;
            if (this.isImportStoreProducts()) {
                IECommerceImporter productImporter = ecommerce.getImporter("M_Product");
                if (productImporter == null) {
                    this.addLog("@ImportProductLoaderNotFound@");
                } else {
                    this.addLog(productImporter.importBatch(this.getCtx(), this.get_TrxName()));
                }
            }
            if (this.isImportStoreCategories()) {
                IECommerceImporter categoryImporter = ecommerce.getImporter("W_Category");
                if (categoryImporter == null) {
                    this.addLog("@ImportCategoryLoaderNotFound@");
                } else {
                    this.addLog(categoryImporter.importBatch(this.getCtx(), this.get_TrxName()));
                }
            }
        }
        return "Ok";
    }
}

