/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.store.model.validator;

import java.util.Arrays;
import java.util.Properties;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeValue;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutConfirm;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementConfirm;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrder;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionBatch;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Util;
import org.eevolution.model.MDDOrder;
import org.spin.model.MADAttachmentReference;
import org.spin.model.MWCategory;
import org.spin.queue.store.support.IECommerceQueue;
import org.spin.queue.util.QueueLoader;
import org.spin.queue.util.QueueManager;

public class ECommercePersistence
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ECommercePersistence.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("M_Product", (ModelValidator)this);
        engine.addModelChange("M_ProductPrice", (ModelValidator)this);
        engine.addModelChange("W_Category", (ModelValidator)this);
        engine.addModelChange("C_TaxCategory", (ModelValidator)this);
        engine.addModelChange("C_Tax", (ModelValidator)this);
        engine.addModelChange("M_Attribute", (ModelValidator)this);
        engine.addModelChange("M_AttributeValue", (ModelValidator)this);
        engine.addModelChange("AD_AttachmentReference", (ModelValidator)this);
        engine.addModelChange("W_CategoryAllocation", (ModelValidator)this);
        engine.addDocValidate("C_Order", (ModelValidator)this);
        engine.addDocValidate("M_Inventory", (ModelValidator)this);
        engine.addDocValidate("M_InOut", (ModelValidator)this);
        engine.addDocValidate("M_Movement", (ModelValidator)this);
        engine.addDocValidate("M_ProductionBatch", (ModelValidator)this);
        engine.addDocValidate("M_Production", (ModelValidator)this);
        engine.addDocValidate("M_MovementConfirm", (ModelValidator)this);
        engine.addDocValidate("M_InOutConfirm", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        if (type == 4 || type == 5) {
            if (entity instanceof MProduct) {
                MProduct product = (MProduct)entity;
                if (type == 5 && (product.isWebStoreFeatured() || product.is_ValueChanged("IsWebStoreFeatured"))) {
                    this.addToQueue(entity, entity.get_TableName(), tableEventValidators[type], product.getSKU());
                }
            } else if (entity instanceof MProductPrice) {
                MProductPrice productPrice = (MProductPrice)entity;
                MProduct product = MProduct.get((Properties)productPrice.getCtx(), (int)productPrice.getM_Product_ID());
                if (product.isWebStoreFeatured()) {
                    this.addToQueue(entity, entity.get_TableName(), tableEventValidators[type], product.getSKU());
                }
            } else if (entity instanceof MADAttachmentReference) {
                MAttachment attachment;
                MADAttachmentReference attachmentReference = (MADAttachmentReference)entity;
                if (attachmentReference.getAD_Attachment_ID() > 0 && (attachment = attachmentReference.getAttachment()) != null && attachment.getAD_Table_ID() == MProduct.Table_ID) {
                    this.addToQueue(entity, entity.get_TableName(), tableEventValidators[type], attachmentReference.getFileName());
                }
            } else {
                this.addToQueue(entity, entity.get_TableName(), tableEventValidators[type], null);
            }
        } else if (type == 6) {
            if (entity instanceof MProduct) {
                MProduct product = (MProduct)entity;
                this.addToQueue(entity, entity.get_TableName(), tableEventValidators[type], product.getSKU());
            } else if (entity instanceof MWCategory) {
                MWCategory group = (MWCategory)entity;
                this.addToQueue(entity, entity.get_TableName(), tableEventValidators[type], group.getValue());
            } else if (entity instanceof MTaxCategory) {
                MTaxCategory taxCategory = (MTaxCategory)entity;
                this.addToQueue(entity, entity.get_TableName(), tableEventValidators[type], taxCategory.getName());
            } else if (entity instanceof MTax) {
                MTax tax = (MTax)entity;
                MTaxCategory taxCategory = (MTaxCategory)tax.getC_TaxCategory();
                this.addToQueue(entity, entity.get_TableName(), tableEventValidators[type], taxCategory.getName());
            } else if (entity instanceof MAttribute) {
                MAttribute attribute = (MAttribute)entity;
                this.addToQueue(entity, entity.get_TableName(), tableEventValidators[type], attribute.getName());
            } else if (entity instanceof MAttributeValue) {
                MAttributeValue attributeValue = (MAttributeValue)entity;
                MAttribute attribute = (MAttribute)attributeValue.getM_Attribute();
                this.addToQueue(entity, entity.get_TableName(), tableEventValidators[type], attribute.getName());
            }
        }
        return null;
    }

    private void addToQueue(PO entity, String sourceTableName, String eventType, String searchValue) {
        QueueManager genericQueue = QueueLoader.getInstance().getQueueManager("ECC").withEntity(entity);
        IECommerceQueue eCommeceQueue = (IECommerceQueue)genericQueue;
        eCommeceQueue.withEventType(eventType);
        eCommeceQueue.withSourceTableName(sourceTableName);
        if (!Util.isEmpty((String)searchValue)) {
            eCommeceQueue.withValue(searchValue);
        }
        genericQueue.addToQueue();
    }

    public String docValidate(PO entity, int timing) {
        if (timing == 9 || timing == 10 || timing == 13 || timing == 14 || timing == 12) {
            if (entity.get_TableName().equals("C_Order")) {
                MOrder order = (MOrder)entity;
                if (order.isSOTrx() && !order.isReturnOrder()) {
                    Arrays.asList(order.getLines()).stream().filter(orderLine -> orderLine.getM_Product_ID() > 0 && orderLine.getM_Product().isWebStoreFeatured()).forEach(orderLine -> this.addToQueue((PO)((MProduct)orderLine.getM_Product()), entity.get_TableName(), "TAC", order.getDocumentNo()));
                }
            } else if (entity.get_TableName().equals("DD_Order")) {
                MDDOrder order = (MDDOrder)entity;
                order.getLines().stream().filter(orderLine -> orderLine.getM_Product_ID() > 0 && orderLine.getM_Product().isWebStoreFeatured()).forEach(orderLine -> this.addToQueue((PO)((MProduct)orderLine.getM_Product()), entity.get_TableName(), "TAC", order.getDocumentNo()));
            } else if (entity.get_TableName().equals("M_InOut")) {
                MInOut inOut = (MInOut)entity;
                Arrays.asList(inOut.getLines()).stream().filter(inOutLine -> inOutLine.getM_Product_ID() > 0 && inOutLine.getM_Product().isWebStoreFeatured()).forEach(inOutLine -> this.addToQueue((PO)((MProduct)inOutLine.getM_Product()), entity.get_TableName(), "TAC", inOut.getDocumentNo()));
            } else if (entity.get_TableName().equals("M_Movement")) {
                MMovement movement = (MMovement)entity;
                Arrays.asList(movement.getLines(true)).stream().filter(movementLine -> movementLine.getM_Product_ID() > 0 && movementLine.getM_Product().isWebStoreFeatured()).forEach(movementLine -> this.addToQueue((PO)((MProduct)movementLine.getM_Product()), entity.get_TableName(), "TAC", movement.getDocumentNo()));
            } else if (entity.get_TableName().equals("M_Production")) {
                MProduction production = (MProduction)entity;
                Arrays.asList(production.getLines()).stream().filter(productionLine -> productionLine.getM_Product_ID() > 0 && productionLine.getM_Product().isWebStoreFeatured()).forEach(productionLine -> this.addToQueue((PO)((MProduct)productionLine.getM_Product()), entity.get_TableName(), "TAC", production.getDocumentNo()));
            } else if (entity.get_TableName().equals("M_InOutConfirm")) {
                MInOutConfirm inOutConfirm = (MInOutConfirm)entity;
                Arrays.asList(inOutConfirm.getLines(true)).stream().filter(inOutConfirmLine -> {
                    MInOutLine inOutLine = (MInOutLine)inOutConfirmLine.getM_InOutLine();
                    if (inOutLine.getM_Product_ID() <= 0) {
                        return false;
                    }
                    return inOutLine.getM_Product().isWebStoreFeatured();
                }).map(inOutConfirmLine -> inOutConfirmLine.getM_InOutLine()).forEach(inOutLine -> this.addToQueue((PO)((MProduct)inOutLine.getM_Product()), entity.get_TableName(), "TAC", inOutConfirm.getDocumentNo()));
            } else if (entity.get_TableName().equals("M_ProductionBatch")) {
                MProductionBatch productionBatch = (MProductionBatch)entity;
                Arrays.asList(productionBatch.getProductionBatchLines(Boolean.valueOf(true))).stream().filter(productionBatchLine -> productionBatchLine.getM_Product_ID() > 0 && productionBatchLine.getM_Product().isWebStoreFeatured()).forEach(productionBatchLine -> this.addToQueue((PO)((MProduct)productionBatchLine.getM_Product()), entity.get_TableName(), "TAC", productionBatch.getDocumentNo()));
            } else if (entity.get_TableName().equals("M_MovementConfirm")) {
                MMovementConfirm movementConfirm = (MMovementConfirm)entity;
                Arrays.asList(movementConfirm.getLines(true)).stream().filter(movementLineConfirm -> {
                    MMovementLine movementLine = (MMovementLine)movementLineConfirm.getM_MovementLine();
                    if (movementLine.getM_Product_ID() <= 0) {
                        return false;
                    }
                    return movementLine.getM_Product().isWebStoreFeatured();
                }).map(movementLineConfirm -> movementLineConfirm.getM_MovementLine()).forEach(movementLine -> this.addToQueue((PO)((MProduct)movementLine.getM_Product()), entity.get_TableName(), "TAC", movementConfirm.getDocumentNo()));
            } else if (entity.get_TableName().equals("M_Inventory")) {
                MInventory inventory = (MInventory)entity;
                Arrays.asList(inventory.getLines(true)).stream().filter(inventoryLine -> inventoryLine.getM_Product_ID() > 0 && inventoryLine.getM_Product().isWebStoreFeatured()).forEach(orderLine -> this.addToQueue((PO)((MProduct)orderLine.getM_Product()), entity.get_TableName(), "TAC", inventory.getDocumentNo()));
            }
        }
        return null;
    }
}

