/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.model.MClient;
import org.compiere.model.MProduct;
import org.compiere.model.MStore;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.model.MADAppRegistration;
import org.spin.queue.model.MADQueue;
import org.spin.queue.process.FlushSystemQueue;
import org.spin.queue.store.model.MWQueue;
import org.spin.queue.store.support.IECommerce;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.queue.store.support.IECommerceQueue;
import org.spin.queue.util.QueueLoader;
import org.spin.queue.util.QueueManager;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;

public class DefaultECommerce
extends QueueManager
implements IECommerceQueue {
    private List<Integer> stores = new ArrayList<Integer>();
    private String eventType;
    private String value;
    private String sourceTableName;
    public static final String QUEUETYPE_Default_E_CommerceQueue = "ECC";

    public QueueManager clear() {
        return this.clearBroker();
    }

    public static DefaultECommerce newInstance() {
        return new DefaultECommerce();
    }

    private DefaultECommerce clearBroker() {
        this.eventType = null;
        DefaultECommerce queue = DefaultECommerce.newInstance();
        if (this.stores != null && this.stores.size() > 0) {
            this.stores.forEach(storeId -> queue.addStore((int)storeId));
        } else {
            Arrays.asList(MStore.getOfClient((MClient)MClient.get((Properties)Env.getCtx()))).forEach(store -> queue.addStore(store.getW_Store_ID()));
        }
        return queue;
    }

    @Override
    public final String getEventType() {
        return this.eventType;
    }

    @Override
    public final DefaultECommerce withEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    @Override
    public final DefaultECommerce withValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public final List<Integer> getStores() {
        return this.stores;
    }

    @Override
    public final DefaultECommerce addStore(int storeId) {
        this.stores.add(storeId);
        return this;
    }

    public void add(int queueId) {
        if (Util.isEmpty((String)this.getEventType())) {
            throw new AdempiereException("@EventModelValidator@ @NotFound@");
        }
        AtomicBoolean isQueued = new AtomicBoolean(false);
        MADQueue queue = new MADQueue(this.getContext(), queueId, this.getTransactionName());
        if (this.getStores().size() > 0) {
            this.getStores().stream().map(storeId -> MStore.get((Properties)this.getContext(), (int)storeId)).filter(store -> store.get_ValueAsInt("CacheServerProvider_ID") > 0).filter(store -> this.isValidToExportToStore((MStore)store)).forEach(store -> {
                if (!isQueued.get()) {
                    isQueued.set(true);
                }
                this.addToQueueBasedOnStoreDefinition(queue, (MStore)store);
            });
        } else {
            Arrays.asList(MStore.getOfClient((MClient)MClient.get((Properties)this.getContext()))).stream().filter(store -> store.get_ValueAsInt("CacheServerProvider_ID") > 0).filter(store -> this.isValidToExportToStore((MStore)store)).forEach(store -> {
                if (!isQueued.get()) {
                    isQueued.set(true);
                }
                this.addToQueueBasedOnStoreDefinition(queue, (MStore)store);
            });
        }
        if (!isQueued.get()) {
            throw new AdempiereException("@W_Store_ID@ @IsMandatory@");
        }
    }

    private void addToQueueBasedOnStoreDefinition(MADQueue queue, MStore store) {
        MWQueue storeQueue = new MWQueue(queue);
        MADAppRegistration registrationAPI = MADAppRegistration.getById((Properties)this.getContext(), (int)store.get_ValueAsInt("CacheServerProvider_ID"), (String)this.getTransactionName());
        storeQueue.setApplicationType(registrationAPI.getApplicationType());
        storeQueue.setAD_AppSupport_ID(registrationAPI.getAD_AppSupport_ID());
        storeQueue.setAD_AppRegistration_ID(registrationAPI.getAD_AppRegistration_ID());
        storeQueue.setEventModelValidator(this.getEventType());
        if (!Util.isEmpty((String)this.getValue())) {
            storeQueue.setValue(this.getValue());
        }
        storeQueue.setW_Store_ID(store.getW_Store_ID());
        storeQueue.saveEx();
        logger.fine("Queue Added: " + storeQueue);
    }

    public void process(int queueId) {
        MADQueue queue = new MADQueue(this.getContext(), queueId, this.getTransactionName());
        MWQueue.getStoresToProcessFromQueue(this.getContext(), queueId, this.getTransactionName()).forEach(storeToProcess -> {
            try {
                IECommerce ecommerceApi = this.getApi(storeToProcess.getAD_AppRegistration_ID(), storeToProcess.getAD_AppSupport_ID(), storeToProcess.getApplicationType());
                if (ecommerceApi == null) {
                    throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@: " + storeToProcess.getW_Store().getName());
                }
                this.processQueue(ecommerceApi, (MWQueue)storeToProcess, queue);
                storeToProcess.setProcessed(true);
                storeToProcess.saveEx();
            }
            catch (Exception e) {
                storeToProcess.setProcessed(false);
                storeToProcess.setErrorMsg(e.getLocalizedMessage());
                storeToProcess.saveEx();
            }
        });
    }

    private void processQueue(IECommerce ecommerceApi, MWQueue storeToProcess, MADQueue queue) throws Exception {
        if (queue.getRecord_ID() <= 0) {
            return;
        }
        if (queue.getAD_Table_ID() <= 0) {
            return;
        }
        MTable tableToProcess = MTable.get((Properties)queue.getCtx(), (int)queue.getAD_Table_ID());
        PO entity = tableToProcess.getPO(queue.getRecord_ID(), queue.get_TrxName());
        IECommerceEntity wrapper = ecommerceApi.getPersistenceWrapper(entity);
        if (wrapper == null) {
            return;
        }
        switch (storeToProcess.getEventModelValidator()) {
            case "TAN": {
                ecommerceApi.connect().create(wrapper.withWebStoreId(storeToProcess.getW_Store_ID())).close();
                break;
            }
            case "TAC": {
                ecommerceApi.connect().update(wrapper.withWebStoreId(storeToProcess.getW_Store_ID())).close();
                break;
            }
            case "TAD": {
                ecommerceApi.connect().delete(wrapper.withWebStoreId(storeToProcess.getW_Store_ID())).close();
                break;
            }
        }
    }

    private MADAppRegistration getRegistration(int apiId, int supportId, String supportType) {
        MADAppRegistration registration = null;
        if (apiId > 0) {
            registration = MADAppRegistration.getById((Properties)this.getContext(), (int)apiId, (String)this.getTransactionName());
        } else if (supportId > 0) {
            registration = (MADAppRegistration)new Query(this.getContext(), "AD_AppRegistration", "AD_AppSupport_ID = ?", this.getTransactionName()).setParameters(new Object[]{supportId}).setOnlyActiveRecords(true).setOrderBy("AD_Client_ID DESC").first();
        } else if (!Util.isEmpty((String)supportType)) {
            registration = MADAppRegistration.getByApplicationType((Properties)this.getContext(), (String)supportType, (String)this.getTransactionName());
        }
        return registration;
    }

    public static void main(String[] args) {
        Adempiere.startup((boolean)true);
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)11);
        Trx.run(transactionName -> {
            DefaultECommerce eCommerceQueue = (DefaultECommerce)QueueLoader.getInstance().getQueueManager(QUEUETYPE_Default_E_CommerceQueue).withContext(Env.getCtx()).withTransactionName(transactionName);
            eCommerceQueue.clearBroker().addStore(11).withTableId(MProduct.Table_ID).withRecordId(50007).addToQueue();
        });
        Trx.run(transactionName -> {
            ProcessInfo result = ProcessBuilder.create((Properties)Env.getCtx()).process(Integer.valueOf(FlushSystemQueue.getProcessId())).withParameter("BatchsToProcess", (Object)1).withParameter("RecordsByBatch", (Object)100).withParameter("IsDeleteAfterProcess", (Object)false).execute();
            logger.fine(result.getSummary());
        });
    }

    @Override
    public IECommerce getApi(int apiId, int supportId, String supportType) {
        try {
            MADAppRegistration registeredApplication = this.getRegistration(apiId, supportId, supportType);
            if (registeredApplication == null) {
                throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@");
            }
            IAppSupport supportedApplication = AppSupportHandler.getInstance().getAppSupport(registeredApplication);
            if (supportedApplication != null && IECommerce.class.isAssignableFrom(supportedApplication.getClass())) {
                return (IECommerce)supportedApplication;
            }
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
            throw new AdempiereException((Throwable)e);
        }
        return null;
    }

    public String toString() {
        return "DefaultECommerce [stores=" + this.stores + ", eventType=" + this.eventType + ", value=" + this.value + "]";
    }

    @Override
    public IECommerceQueue withSourceTableName(String sourceTableName) {
        this.sourceTableName = sourceTableName;
        return this;
    }

    private boolean isValidToExportToStore(MStore store) {
        if (store == null || Util.isEmpty((String)this.sourceTableName)) {
            return false;
        }
        if (store.get_ValueAsBoolean("ECA35_ExportProduct") && (this.sourceTableName.equals("M_Product") || this.sourceTableName.equals("W_Category") || this.sourceTableName.equals("C_TaxCategory") || this.sourceTableName.equals("C_Tax") || this.sourceTableName.equals("M_Attribute") || this.sourceTableName.equals("M_AttributeValue") || this.sourceTableName.equals("AD_AttachmentReference") || this.sourceTableName.equals("W_CategoryAllocation"))) {
            return true;
        }
        if (store.get_ValueAsBoolean("ECA35_ExportPriceList") && (this.sourceTableName.equals("M_ProductPrice") || this.sourceTableName.equals("M_PriceList") || this.sourceTableName.equals("M_PriceList_Version"))) {
            return true;
        }
        return store.get_ValueAsBoolean("ECA35_ExportStock") && (this.sourceTableName.equals("C_Order") || this.sourceTableName.equals("M_Inventory") || this.sourceTableName.equals("M_InOut") || this.sourceTableName.equals("M_Movement") || this.sourceTableName.equals("M_ProductionBatch") || this.sourceTableName.equals("M_Production") || this.sourceTableName.equals("M_MovementConfirm") || this.sourceTableName.equals("M_InOutConfirm"));
    }
}

