/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.farming.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.compiere.util.CLogger;
import org.erpya.lve.farming.util.CategoryType;

public class CategoryTypeUtils {
    private static final CLogger logger = CLogger.getCLogger(CategoryTypeUtils.class);
    public static final String CATEGORY_DAMP_RICE = "DAR";
    public static final String CATEGORY_DAMP_WHITE_CORN = "DAWC";
    public static final String CATEGORY_DAMP_YELLOW_CORN = "DAYC";
    public static final String CATEGORY_DRIED_RICE = "DRR";
    public static final String CATEGORY_DRIED_WHITE_CORN = "DRWC";
    public static final String CATEGORY_DRIED_YELLOW_CORN = "DRYC";
    public static final String CATEGORY_TYPE_I = "I";
    public static final String CATEGORY_TYPE_II = "II";
    public static final String CATEGORY_TYPE_III = "III";
    public static final String CATEGORY_TYPE_IV = "NC";
    private static UnaryOperator<Integer> increment = value -> value + 10;

    public static String getCategoryType(HashMap<Integer, Map<String, BigDecimal>> categoryParameters, List<CategoryType> categoryDefinitionTable) {
        AtomicReference<String> currentCategoryType = new AtomicReference<String>(CATEGORY_TYPE_I);
        AtomicReference<Integer> currentCategoryTypeSequence = new AtomicReference<Integer>(10);
        AtomicReference<Integer> currentCategorySequence = new AtomicReference<Integer>(10);
        HashMap<String, HashMap<Integer, Map<String, BigDecimal>>> pupulatedCategoryParameters = CategoryTypeUtils.populateParameters(categoryParameters);
        pupulatedCategoryParameters.entrySet().stream().sorted(Comparator.comparing(categoryPopulatedParameters -> (String)categoryPopulatedParameters.getKey())).forEach(populatedParameters -> {
            HashMap parameters = (HashMap)populatedParameters.getValue();
            parameters.entrySet().stream().sorted(Comparator.comparing(parameter -> (Integer)parameter.getKey())).filter(parameter -> ((Integer)parameter.getKey()).equals(currentCategorySequence.get()) && ((String)populatedParameters.getKey()).equals(currentCategoryType.get())).map(parameter -> (Map)parameter.getValue()).forEach(parameter -> parameter.entrySet().forEach(categoryParameter -> {
                logger.fine(categoryParameter.toString());
                categoryDefinitionTable.stream().sorted(Comparator.comparing(CategoryType::getSequenceNumber)).filter(categoryTable -> categoryTable.getCategoryType().equals(populatedParameters.getKey()) && categoryTable.getAttributeTag().equals(categoryParameter.getKey())).forEach(categoryRow -> {
                    logger.fine(categoryRow.toString());
                    if (categoryRow.checkValue((BigDecimal)categoryParameter.getValue())) {
                        currentCategoryType.set(categoryRow.getCategoryType());
                        currentCategorySequence.set((Integer)currentCategorySequence.get() + 10);
                    } else if (!categoryDefinitionTable.stream().anyMatch(categoryTablePreviuosType -> categoryTablePreviuosType.getAttributeTag().equals(categoryParameter.getKey()) && categoryTablePreviuosType.getSequenceNumber() < (Integer)currentCategoryTypeSequence.get() && categoryTablePreviuosType.checkValue((BigDecimal)categoryParameter.getValue()))) {
                        currentCategoryType.set(categoryRow.getNextCategoryType());
                        currentCategoryTypeSequence.updateAndGet(increment);
                    } else {
                        currentCategorySequence.updateAndGet(increment);
                    }
                });
            }));
        });
        return currentCategoryType.get();
    }

    private static HashMap<String, HashMap<Integer, Map<String, BigDecimal>>> populateParameters(HashMap<Integer, Map<String, BigDecimal>> categoryParameters) {
        HashMap<String, HashMap<Integer, Map<String, BigDecimal>>> result = new HashMap<String, HashMap<Integer, Map<String, BigDecimal>>>();
        List<String> categoryTypes = Arrays.asList(CATEGORY_TYPE_I, CATEGORY_TYPE_II, CATEGORY_TYPE_III, CATEGORY_TYPE_IV);
        categoryTypes.stream().forEach(categoryType -> result.put((String)categoryType, categoryParameters));
        return result;
    }
}

