/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.farming.util;

import java.math.BigDecimal;
import java.util.Optional;
import org.compiere.util.Env;

public class CategoryType {
    private String categoryType = "";
    private String nextCategoryType = "";
    private BigDecimal minValue = Env.ZERO;
    private BigDecimal maxValue = Env.ZERO;
    private String attributeTag = "";
    private int sequenceNumber = 0;

    public CategoryType(String categoryType, String nextCategoryType, String attributeTag, int sequenceNumber, BigDecimal minValue, BigDecimal maxValue) {
        this.setCategoryType(categoryType);
        this.setNextCategoryType(nextCategoryType);
        this.setAttributeTag(attributeTag);
        this.setSequenceNumber(sequenceNumber);
        this.setMinValue(minValue);
        this.setMaxValue(maxValue);
    }

    public boolean checkValue(BigDecimal value) {
        BigDecimal minValue = Optional.ofNullable(this.getMinValue()).orElse(Env.ZERO);
        BigDecimal maxValue = Optional.ofNullable(this.getMaxValue()).orElse(new BigDecimal(999999999));
        BigDecimal valueToEvaluate = Optional.ofNullable(value).orElse(Env.ZERO);
        return valueToEvaluate.compareTo(minValue) >= 0 && valueToEvaluate.compareTo(maxValue) <= 0;
    }

    public String getCategoryType() {
        return this.categoryType;
    }

    public void setCategoryType(String categoryType) {
        this.categoryType = categoryType;
    }

    public BigDecimal getMinValue() {
        return this.minValue;
    }

    public void setMinValue(BigDecimal minValue) {
        this.minValue = minValue;
    }

    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(BigDecimal maxValue) {
        this.maxValue = maxValue;
    }

    public String getAttributeTag() {
        return this.attributeTag;
    }

    public void setAttributeTag(String attributeTag) {
        this.attributeTag = attributeTag;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getNextCategoryType() {
        return this.nextCategoryType;
    }

    public void setNextCategoryType(String nextCategoryType) {
        this.nextCategoryType = nextCategoryType;
    }

    public String toString() {
        return Optional.ofNullable(Integer.toString(this.getSequenceNumber())).orElse("").concat(" | ").concat(Optional.ofNullable(this.getCategoryType()).orElse("")).concat(" | ").concat(Optional.ofNullable(this.getAttributeTag()).orElse("")).concat(" | ").concat(">=").concat(Optional.ofNullable(this.getMinValue().toString()).orElse("")).concat(" ").concat("<=").concat(Optional.ofNullable(this.getMaxValue().toString()).orElse("")).concat(Env.NL);
    }
}

