/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.farming.setup;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeUse;
import org.erpya.lve.farming.engine.Rice_ConditionedWeight;
import org.erpya.lve.farming.engine.Rice_PaidWeight;
import org.erpya.lve.farming.setup.AttributeCategory;
import org.farming.model.MFAPWeightCalculation;
import org.farming.model.MFAPWeightCalculationType;
import org.spin.util.ISetupDefinition;

public class RiceDefinition
implements ISetupDefinition {
    public String doIt(Properties context, String transactionName) {
        this.createAttributeSet(context, transactionName);
        this.createCalculations(context, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private void createAttributeSet(Properties context, String transactionName) {
        MAttributeSet attributeSetForRice = new MAttributeSet(context, 0, transactionName);
        attributeSetForRice.setName("Attributes for Rice");
        attributeSetForRice.setDescription("(*Created from Setup Automatically*)");
        attributeSetForRice.setMandatoryType("N");
        attributeSetForRice.saveEx();
        this.getAttributesForRice(context, transactionName).forEach(attribute -> {
            MAttributeUse attributeUse = new MAttributeUse(context, 0, transactionName);
            attributeUse.setM_AttributeSet_ID(attributeSetForRice.get_ID());
            attributeUse.setM_Attribute_ID(attribute.getAttribute().get_ID());
            attributeUse.saveEx();
        });
    }

    private void createCalculations(Properties context, String transactionName) {
        MFAPWeightCalculationType weightCalculationType = new MFAPWeightCalculationType(context, 0, transactionName);
        weightCalculationType.setValue("Calculation Type for Rice");
        weightCalculationType.setName("Calculation Type for Rice");
        weightCalculationType.setDescription("(*Created from Setup Automatically*)");
        weightCalculationType.saveEx();
        MFAPWeightCalculation conditionedWeightCalculation = new MFAPWeightCalculation(context, 0, transactionName);
        conditionedWeightCalculation.setFAP_WeightCalculationType_ID(weightCalculationType.get_ID());
        conditionedWeightCalculation.setValue("Conditioned Weight");
        conditionedWeightCalculation.setName("Conditioned Weight");
        conditionedWeightCalculation.setDescription("(*Created from Setup Automatically*)");
        conditionedWeightCalculation.setUsingType("RW");
        conditionedWeightCalculation.setClassname(Rice_ConditionedWeight.class.getName());
        conditionedWeightCalculation.setSeqNo(10);
        conditionedWeightCalculation.saveEx();
        MFAPWeightCalculation paidWeightCalculation = new MFAPWeightCalculation(context, 0, transactionName);
        paidWeightCalculation.setFAP_WeightCalculationType_ID(weightCalculationType.get_ID());
        paidWeightCalculation.setValue("Paid Weight");
        paidWeightCalculation.setName("Paid Weight");
        paidWeightCalculation.setDescription("(*Created from Setup Automatically*)");
        paidWeightCalculation.setUsingType("PC");
        paidWeightCalculation.setClassname(Rice_PaidWeight.class.getName());
        paidWeightCalculation.setSeqNo(10);
        paidWeightCalculation.saveEx();
    }

    private List<AttributeCategory> getAttributesForRice(Properties context, String transactionName) {
        ArrayList<AttributeCategory> attributesForRice = new ArrayList<AttributeCategory>();
        attributesForRice.add(new AttributeCategory(context, transactionName).withValue("Humidity").withName("Humedad").withType("N"));
        attributesForRice.add(new AttributeCategory(context, transactionName).withValue("EntireGrains").withName("Granos Enteros").withType("N"));
        attributesForRice.add(new AttributeCategory(context, transactionName).withValue("GreenGrains").withName("Granos Verdes").withType("N"));
        attributesForRice.add(new AttributeCategory(context, transactionName).withValue("StainedGrains").withName("Granos Manchados").withType("N"));
        attributesForRice.add(new AttributeCategory(context, transactionName).withValue("ObjectionableSeeds").withName("Semillas Objetables").withType("N"));
        attributesForRice.add(new AttributeCategory(context, transactionName).withValue("TotalDamagedGrains").withName("Granos Da\u00f1ados Total").withType("N"));
        attributesForRice.add(new AttributeCategory(context, transactionName).withValue("Scrap").withName("Impureza").withType("N"));
        attributesForRice.add(new AttributeCategory(context, transactionName).withValue("GrainsWithGypsum").withName("Granos Yesosos").withType("N"));
        attributesForRice.add(new AttributeCategory(context, transactionName).withValue("RedGrains").withName("Granos Rojos").withType("N"));
        attributesForRice.add(new AttributeCategory(context, transactionName).withValue("DamagedGrains").withName("Granos Da\u00f1ados").withType("N"));
        attributesForRice.add(new AttributeCategory(context, transactionName).withValue("Specific Weight").withName("Peso Especifico").withType("N"));
        attributesForRice.add(new AttributeCategory(context, transactionName).withValue("TotalBlank").withName("Blanco Total").withType("N"));
        attributesForRice.add(new AttributeCategory(context, transactionName).withValue("GrainsBellyBlank").withName("Granos Panza Blanca").withType("N"));
        attributesForRice.add(new AttributeCategory(context, transactionName).withValue("BlackEndGrains").withName("Granos Punta Negra").withType("N"));
        attributesForRice.add(new AttributeCategory(context, transactionName).withValue("Grains Without Shell").withName("Granos Sin Cascara").withType("N"));
        return attributesForRice;
    }
}

