/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.farming.setup;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeUse;
import org.erpya.lve.farming.engine.WhiteCorn_ConditionedWeight;
import org.erpya.lve.farming.engine.YellowCorn_ConditionedWeight;
import org.erpya.lve.farming.setup.AttributeCategory;
import org.farming.model.MFAPWeightCalculation;
import org.farming.model.MFAPWeightCalculationType;
import org.spin.util.ISetupDefinition;

public class CornDefinition
implements ISetupDefinition {
    private static final String AttributeSet_Corn = "Attributes for Corn";
    private static final String CalculationType_Corn = "Calculation Type for Corn";

    public String doIt(Properties context, String transactionName) {
        this.createAttributeSet(context, transactionName);
        this.createCalculations(context, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private void createAttributeSet(Properties context, String transactionName) {
        MAttributeSet attributeSetForCorn = new MAttributeSet(context, 0, transactionName);
        attributeSetForCorn.setName(AttributeSet_Corn);
        attributeSetForCorn.setDescription("(*Created from Setup Automatically*)");
        attributeSetForCorn.setMandatoryType("N");
        attributeSetForCorn.saveEx();
        this.getAttributesForCorn(context, transactionName).forEach(attribute -> {
            MAttributeUse attributeUse = new MAttributeUse(context, 0, transactionName);
            attributeUse.setM_AttributeSet_ID(attributeSetForCorn.get_ID());
            attributeUse.setM_Attribute_ID(attribute.getAttribute().get_ID());
            attributeUse.saveEx();
        });
    }

    private void createCalculations(Properties context, String transactionName) {
        MFAPWeightCalculationType weightCalculationType = new MFAPWeightCalculationType(context, 0, transactionName);
        weightCalculationType.setValue(CalculationType_Corn);
        weightCalculationType.setName(CalculationType_Corn);
        weightCalculationType.setDescription("(*Created from Setup Automatically*)");
        weightCalculationType.saveEx();
        MFAPWeightCalculation conditionedWeightCalculation = new MFAPWeightCalculation(context, 0, transactionName);
        conditionedWeightCalculation.setFAP_WeightCalculationType_ID(weightCalculationType.get_ID());
        conditionedWeightCalculation.setValue("Conditioned Weight");
        conditionedWeightCalculation.setName("Conditioned Weight");
        conditionedWeightCalculation.setDescription("(*Created from Setup Automatically*)");
        conditionedWeightCalculation.setUsingType("RW");
        conditionedWeightCalculation.setClassname(WhiteCorn_ConditionedWeight.class.getName());
        conditionedWeightCalculation.setSeqNo(10);
        conditionedWeightCalculation.saveEx();
        MFAPWeightCalculation paidWeightCalculation = new MFAPWeightCalculation(context, 0, transactionName);
        paidWeightCalculation.setFAP_WeightCalculationType_ID(weightCalculationType.get_ID());
        paidWeightCalculation.setValue("Paid Weight");
        paidWeightCalculation.setName("Paid Weight");
        paidWeightCalculation.setDescription("(*Created from Setup Automatically*)");
        paidWeightCalculation.setUsingType("PC");
        paidWeightCalculation.setClassname(WhiteCorn_ConditionedWeight.class.getName());
        paidWeightCalculation.setSeqNo(10);
        paidWeightCalculation.saveEx();
        conditionedWeightCalculation = new MFAPWeightCalculation(context, 0, transactionName);
        conditionedWeightCalculation.setFAP_WeightCalculationType_ID(weightCalculationType.get_ID());
        conditionedWeightCalculation.setValue("Conditioned Weight");
        conditionedWeightCalculation.setName("Conditioned Weight");
        conditionedWeightCalculation.setDescription("(*Created from Setup Automatically*)");
        conditionedWeightCalculation.setUsingType("RW");
        conditionedWeightCalculation.setClassname(YellowCorn_ConditionedWeight.class.getName());
        conditionedWeightCalculation.setSeqNo(20);
        conditionedWeightCalculation.saveEx();
        paidWeightCalculation = new MFAPWeightCalculation(context, 0, transactionName);
        paidWeightCalculation.setFAP_WeightCalculationType_ID(weightCalculationType.get_ID());
        paidWeightCalculation.setValue("Paid Weight");
        paidWeightCalculation.setName("Paid Weight");
        paidWeightCalculation.setDescription("(*Created from Setup Automatically*)");
        paidWeightCalculation.setUsingType("PC");
        paidWeightCalculation.setClassname(YellowCorn_ConditionedWeight.class.getName());
        paidWeightCalculation.setSeqNo(20);
        paidWeightCalculation.saveEx();
    }

    private List<AttributeCategory> getAttributesForCorn(Properties context, String transactionName) {
        ArrayList<AttributeCategory> attributesForCorn = new ArrayList<AttributeCategory>();
        attributesForCorn.add(new AttributeCategory(context, transactionName).withValue("Humidity").withName("Humedad").withType("N"));
        attributesForCorn.add(new AttributeCategory(context, transactionName).withValue("Scrap").withName("Impureza").withType("N"));
        attributesForCorn.add(new AttributeCategory(context, transactionName).withValue("TotalDamagedGrains").withName("Granos Da\u00f1ados Total").withType("N"));
        attributesForCorn.add(new AttributeCategory(context, transactionName).withValue("CrackedGrains").withName("Granos Partidos").withType("N"));
        attributesForCorn.add(new AttributeCategory(context, transactionName).withValue("HeatDamagedGrains").withName("Granos Da\u00f1ados por el Calor").withType("N"));
        attributesForCorn.add(new AttributeCategory(context, transactionName).withValue("CrystallizedGrains").withName("Granos Cristalizados").withType("N"));
        attributesForCorn.add(new AttributeCategory(context, transactionName).withValue("ReheatedGrains").withName("Granos Recalentados").withType("N"));
        attributesForCorn.add(new AttributeCategory(context, transactionName).withValue("ColorMix").withName("Mezcla de Color").withType("N"));
        attributesForCorn.add(new AttributeCategory(context, transactionName).withValue("ObjectionableSeeds").withName("Semillas Objetables").withType("N"));
        attributesForCorn.add(new AttributeCategory(context, transactionName).withValue("Aflatoxin").withName("Aflatoxina").withType("N"));
        attributesForCorn.add(new AttributeCategory(context, transactionName).withValue("VolumetricWeight").withName("Peso Volum\u00e9trico").withType("N"));
        return attributesForCorn;
    }
}

