/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.farming.setup;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeUse;
import org.erpya.lve.farming.engine.Bean_ConditionedWeight;
import org.erpya.lve.farming.engine.Bean_PaidWeight;
import org.erpya.lve.farming.setup.AttributeCategory;
import org.farming.model.MFAPWeightCalculation;
import org.farming.model.MFAPWeightCalculationType;
import org.spin.util.ISetupDefinition;

public class BeanDefinition
implements ISetupDefinition {
    public String doIt(Properties context, String transactionName) {
        this.createAttributeSet(context, transactionName);
        this.createCalculations(context, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private void createAttributeSet(Properties context, String transactionName) {
        MAttributeSet attributeSetForBean = new MAttributeSet(context, 0, transactionName);
        attributeSetForBean.setName("Attributes for Bean");
        attributeSetForBean.setDescription("(*Created from Setup Automatically*)");
        attributeSetForBean.setMandatoryType("N");
        attributeSetForBean.saveEx();
        this.getAttributesForBean(context, transactionName).forEach(attribute -> {
            MAttributeUse attributeUse = new MAttributeUse(context, 0, transactionName);
            attributeUse.setM_AttributeSet_ID(attributeSetForBean.get_ID());
            attributeUse.setM_Attribute_ID(attribute.getAttribute().get_ID());
            attributeUse.saveEx();
        });
    }

    private void createCalculations(Properties context, String transactionName) {
        MFAPWeightCalculationType weightCalculationType = new MFAPWeightCalculationType(context, 0, transactionName);
        weightCalculationType.setValue("Calculation Type for Bean");
        weightCalculationType.setName("Calculation Type for Bean");
        weightCalculationType.setDescription("(*Created from Setup Automatically*)");
        weightCalculationType.saveEx();
        MFAPWeightCalculation conditionedWeightCalculation = new MFAPWeightCalculation(context, 0, transactionName);
        conditionedWeightCalculation.setFAP_WeightCalculationType_ID(weightCalculationType.get_ID());
        conditionedWeightCalculation.setValue("Conditioned Weight");
        conditionedWeightCalculation.setName("Conditioned Weight");
        conditionedWeightCalculation.setDescription("(*Created from Setup Automatically*)");
        conditionedWeightCalculation.setUsingType("RW");
        conditionedWeightCalculation.setClassname(Bean_ConditionedWeight.class.getName());
        conditionedWeightCalculation.setSeqNo(10);
        conditionedWeightCalculation.saveEx();
        MFAPWeightCalculation paidWeightCalculation = new MFAPWeightCalculation(context, 0, transactionName);
        paidWeightCalculation.setFAP_WeightCalculationType_ID(weightCalculationType.get_ID());
        paidWeightCalculation.setValue("Paid Weight");
        paidWeightCalculation.setName("Paid Weight");
        paidWeightCalculation.setDescription("(*Created from Setup Automatically*)");
        paidWeightCalculation.setUsingType("PC");
        paidWeightCalculation.setClassname(Bean_PaidWeight.class.getName());
        paidWeightCalculation.setSeqNo(10);
        paidWeightCalculation.saveEx();
    }

    private List<AttributeCategory> getAttributesForBean(Properties context, String transactionName) {
        ArrayList<AttributeCategory> attributesForBean = new ArrayList<AttributeCategory>();
        attributesForBean.add(new AttributeCategory(context, transactionName).withValue("Odor").withName("Olor").withType("S"));
        attributesForBean.add(new AttributeCategory(context, transactionName).withValue("Color").withName("Color").withType("N"));
        attributesForBean.add(new AttributeCategory(context, transactionName).withValue("Humidity").withName("Humedad").withType("N"));
        attributesForBean.add(new AttributeCategory(context, transactionName).withValue("Size").withName("Tama\u00f1o").withType("N"));
        attributesForBean.add(new AttributeCategory(context, transactionName).withValue("Scrap").withName("Impureza").withType("N"));
        attributesForBean.add(new AttributeCategory(context, transactionName).withValue("CrackedGrains").withName("Granos Partidos").withType("N"));
        attributesForBean.add(new AttributeCategory(context, transactionName).withValue("DamagedGrains").withName("Granos Da\u00f1ados").withType("N"));
        attributesForBean.add(new AttributeCategory(context, transactionName).withValue("TotalDamagedGrains").withName("Granos Da\u00f1ados Total").withType("N"));
        attributesForBean.add(new AttributeCategory(context, transactionName).withValue("Germinated").withName("Germinados").withType("N"));
        attributesForBean.add(new AttributeCategory(context, transactionName).withValue("Moldy").withName("Enmohecido").withType("N"));
        return attributesForBean;
    }
}

