/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.farming.engine;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MProduct;
import org.compiere.util.Env;
import org.erpya.lve.farming.util.CategoryType;
import org.erpya.lve.farming.util.CategoryTypeUtils;
import org.farming.engine.CategoryEngine;

public class WhiteCorn_ConditionedWeight
extends CategoryEngine {
    private static final BigDecimal CONSTANT_88 = new BigDecimal(88);
    private static final BigDecimal CONSTANT_12 = new BigDecimal(12);
    private static final BigDecimal CONSTANT_14 = new BigDecimal(14);
    private static final String CONSTANT_I = new String("I");
    private static final List<CategoryType> dampWhiteCornTable = Arrays.asList(new CategoryType("I", "II", "TotalDamagedGrains", 10, new BigDecimal(0), new BigDecimal(6)), new CategoryType("I", "II", "CrackedGrains", 10, new BigDecimal(0), new BigDecimal(3)), new CategoryType("I", "II", "HeatDamagedGrains", 10, new BigDecimal(0), new BigDecimal(1)), new CategoryType("I", "II", "CrystallizedGrains", 10, new BigDecimal(0), new BigDecimal(5)), new CategoryType("I", "II", "ReheatedGrains", 10, new BigDecimal(0), new BigDecimal(0)), new CategoryType("I", "II", "ColorMix", 10, new BigDecimal(0), new BigDecimal(3)), new CategoryType("I", "II", "ObjectionableSeeds", 10, new BigDecimal(0), new BigDecimal(0)), new CategoryType("I", "II", "Aflatoxin", 10, new BigDecimal(0), new BigDecimal(0)), new CategoryType("II", "III", "TotalDamagedGrains", 20, new BigDecimal(6.01), new BigDecimal(8)), new CategoryType("II", "III", "CrackedGrains", 20, new BigDecimal(3.01), new BigDecimal(5)), new CategoryType("II", "III", "HeatDamagedGrains", 20, new BigDecimal(1.01), new BigDecimal(2)), new CategoryType("II", "III", "CrystallizedGrains", 20, new BigDecimal(5.01), new BigDecimal(10)), new CategoryType("II", "III", "ReheatedGrains", 20, new BigDecimal(0), new BigDecimal(0)), new CategoryType("II", "III", "ColorMix", 20, new BigDecimal(0), new BigDecimal(3)), new CategoryType("II", "III", "ObjectionableSeeds", 20, new BigDecimal(0), new BigDecimal(0)), new CategoryType("II", "III", "Aflatoxin", 20, new BigDecimal(0), new BigDecimal(0)), new CategoryType("III", "NC", "TotalDamagedGrains", 30, new BigDecimal(8.01), new BigDecimal(11)), new CategoryType("III", "NC", "CrackedGrains", 30, new BigDecimal(5.01), new BigDecimal(7)), new CategoryType("III", "NC", "HeatDamagedGrains", 30, new BigDecimal(2.01), new BigDecimal(3)), new CategoryType("III", "NC", "CrystallizedGrains", 30, new BigDecimal(10.01), new BigDecimal(15)), new CategoryType("III", "NC", "ReheatedGrains", 30, new BigDecimal(0.1), new BigDecimal(0.29)), new CategoryType("III", "NC", "ColorMix", 30, new BigDecimal(0), new BigDecimal(3)), new CategoryType("III", "NC", "ObjectionableSeeds", 30, new BigDecimal(0.1), new BigDecimal(1)), new CategoryType("III", "NC", "Aflatoxin", 30, new BigDecimal(0), new BigDecimal(0)), new CategoryType("NC", "NC", "TotalDamagedGrains", 40, new BigDecimal(11.01), new BigDecimal(12)), new CategoryType("NC", "NC", "CrackedGrains", 40, new BigDecimal(7.01), new BigDecimal(8)), new CategoryType("NC", "NC", "HeatDamagedGrains", 40, new BigDecimal(3.01), new BigDecimal(4)), new CategoryType("NC", "NC", "CrystallizedGrains", 40, new BigDecimal(15.01), new BigDecimal(16)), new CategoryType("NC", "NC", "ReheatedGrains", 40, new BigDecimal(0.3), new BigDecimal(0.4)), new CategoryType("NC", "NC", "ColorMix", 40, new BigDecimal(3), new BigDecimal(4)), new CategoryType("NC", "NC", "ObjectionableSeeds", 40, new BigDecimal(1.01), new BigDecimal(2)), new CategoryType("NC", "NC", "Aflatoxin", 40, new BigDecimal(1), new BigDecimal(5)));
    private static final List<CategoryType> driedWhiteCornTable = Arrays.asList(new CategoryType("I", "II", "TotalDamagedGrains", 10, new BigDecimal(0), new BigDecimal(6)), new CategoryType("I", "II", "CrackedGrains", 10, new BigDecimal(0), new BigDecimal(3)), new CategoryType("I", "II", "HeatDamagedGrains", 10, new BigDecimal(0), new BigDecimal(1)), new CategoryType("I", "II", "CrystallizedGrains", 10, new BigDecimal(0), new BigDecimal(5)), new CategoryType("I", "II", "ReheatedGrains", 10, new BigDecimal(0), new BigDecimal(0)), new CategoryType("I", "II", "ColorMix", 10, new BigDecimal(0), new BigDecimal(3)), new CategoryType("I", "II", "ObjectionableSeeds", 10, new BigDecimal(0), new BigDecimal(0)), new CategoryType("I", "II", "Aflatoxin", 10, new BigDecimal(0), new BigDecimal(0)), new CategoryType("II", "III", "TotalDamagedGrains", 20, new BigDecimal(6.01), new BigDecimal(8)), new CategoryType("II", "III", "CrackedGrains", 20, new BigDecimal(3.01), new BigDecimal(5)), new CategoryType("II", "III", "HeatDamagedGrains", 20, new BigDecimal(1.01), new BigDecimal(2)), new CategoryType("II", "III", "CrystallizedGrains", 20, new BigDecimal(5.01), new BigDecimal(10)), new CategoryType("II", "III", "ReheatedGrains", 20, new BigDecimal(0), new BigDecimal(0)), new CategoryType("II", "III", "ColorMix", 20, new BigDecimal(0), new BigDecimal(3)), new CategoryType("II", "III", "ObjectionableSeeds", 20, new BigDecimal(0), new BigDecimal(0)), new CategoryType("II", "III", "Aflatoxin", 20, new BigDecimal(0), new BigDecimal(0)), new CategoryType("III", "NC", "TotalDamagedGrains", 30, new BigDecimal(8.01), new BigDecimal(11)), new CategoryType("III", "NC", "CrackedGrains", 30, new BigDecimal(5.01), new BigDecimal(7)), new CategoryType("III", "NC", "HeatDamagedGrains", 30, new BigDecimal(2.01), new BigDecimal(3)), new CategoryType("III", "NC", "CrystallizedGrains", 30, new BigDecimal(10.01), new BigDecimal(15)), new CategoryType("III", "NC", "ReheatedGrains", 30, new BigDecimal(0), new BigDecimal(0.2)), new CategoryType("III", "NC", "ColorMix", 30, new BigDecimal(0), new BigDecimal(0.29)), new CategoryType("III", "NC", "ObjectionableSeeds", 30, new BigDecimal(0.1), new BigDecimal(1)), new CategoryType("III", "NC", "Aflatoxin", 30, new BigDecimal(0), new BigDecimal(0)), new CategoryType("NC", "NC", "TotalDamagedGrains", 40, new BigDecimal(11.01), new BigDecimal(12)), new CategoryType("NC", "NC", "CrackedGrains", 40, new BigDecimal(7.01), new BigDecimal(8)), new CategoryType("NC", "NC", "HeatDamagedGrains", 40, new BigDecimal(3.01), new BigDecimal(4)), new CategoryType("NC", "NC", "CrystallizedGrains", 40, new BigDecimal(15.01), new BigDecimal(16)), new CategoryType("NC", "NC", "ReheatedGrains", 40, new BigDecimal(0.21), new BigDecimal(0.3)), new CategoryType("NC", "NC", "ColorMix", 40, new BigDecimal(3), new BigDecimal(4)), new CategoryType("NC", "NC", "ObjectionableSeeds", 40, new BigDecimal(1.01), new BigDecimal(2)), new CategoryType("NC", "NC", "Aflatoxin", 40, new BigDecimal(1), new BigDecimal(5)));

    public BigDecimal calculate(Properties context, int bPartnerId, int productId, Timestamp date, BigDecimal netWeight, Map<String, Object> parameters, String transactionName) {
        BigDecimal humidity;
        MProduct product = MProduct.get((Properties)context, (int)productId);
        int precision = product.getUOMPrecision();
        BigDecimal humidityCalculated = humidity = Optional.ofNullable((BigDecimal)parameters.get("Humidity")).orElse(Env.ZERO);
        BigDecimal impurity = Optional.ofNullable((BigDecimal)parameters.get("Scrap")).orElse(Env.ZERO);
        netWeight = Optional.ofNullable(netWeight).orElse(Env.ZERO);
        BigDecimal totalDamagedGrains = Optional.ofNullable((BigDecimal)parameters.get("TotalDamagedGrains")).orElse(Env.ZERO);
        BigDecimal crackedGrains = Optional.ofNullable((BigDecimal)parameters.get("CrackedGrains")).orElse(Env.ZERO);
        BigDecimal heatDamagedGrains = Optional.ofNullable((BigDecimal)parameters.get("HeatDamagedGrains")).orElse(Env.ZERO);
        BigDecimal crystallizedGrains = Optional.ofNullable((BigDecimal)parameters.get("CrystallizedGrains")).orElse(Env.ZERO);
        BigDecimal reheatedGrains = Optional.ofNullable((BigDecimal)parameters.get("ReheatedGrains")).orElse(Env.ZERO);
        BigDecimal colorMix = Optional.ofNullable((BigDecimal)parameters.get("ColorMix")).orElse(Env.ZERO);
        BigDecimal objectionableSeeds = Optional.ofNullable((BigDecimal)parameters.get("ObjectionableSeeds")).orElse(Env.ZERO);
        BigDecimal aflatoxin = Optional.ofNullable((BigDecimal)parameters.get("Aflatoxin")).orElse(Env.ZERO);
        String _C_Variable = CONSTANT_I;
        humidityCalculated = humidity.compareTo(CONSTANT_12) <= 0 ? CONSTANT_12 : humidity;
        BigDecimal _A_Variable = netWeight.multiply(humidityCalculated.subtract(CONSTANT_12).divide(CONSTANT_88, MathContext.DECIMAL128)).setScale(precision, 4);
        BigDecimal _B_Variable = Env.ZERO;
        if (impurity.compareTo(Env.ZERO) > 0) {
            _B_Variable = netWeight.subtract(_A_Variable).multiply(impurity.divide(Env.ONEHUNDRED, MathContext.DECIMAL128)).setScale(precision, 4);
        }
        HashMap<Integer, Map<String, BigDecimal>> cornParameters = new HashMap<Integer, Map<String, BigDecimal>>();
        cornParameters.put(new Integer(10), Collections.singletonMap("TotalDamagedGrains", totalDamagedGrains));
        cornParameters.put(new Integer(20), Collections.singletonMap("CrackedGrains", crackedGrains));
        cornParameters.put(new Integer(30), Collections.singletonMap("HeatDamagedGrains", heatDamagedGrains));
        cornParameters.put(new Integer(40), Collections.singletonMap("CrystallizedGrains", crystallizedGrains));
        cornParameters.put(new Integer(50), Collections.singletonMap("ReheatedGrains", reheatedGrains));
        cornParameters.put(new Integer(60), Collections.singletonMap("ColorMix", colorMix));
        cornParameters.put(new Integer(70), Collections.singletonMap("ObjectionableSeeds", objectionableSeeds));
        cornParameters.put(new Integer(80), Collections.singletonMap("Aflatoxin", aflatoxin));
        this.addCategoryValue("HumidityDiscount", _A_Variable);
        this.addCategoryValue("ScrapDiscount", _B_Variable);
        if (humidity.compareTo(CONSTANT_14) >= 0) {
            this.addCategoryValue("ConditionType", "HUMEDO");
            _C_Variable = CategoryTypeUtils.getCategoryType(cornParameters, dampWhiteCornTable);
            this.addCategoryValue("CornType", _C_Variable);
        } else {
            this.addCategoryValue("ConditionType", "SECO");
            _C_Variable = CategoryTypeUtils.getCategoryType(cornParameters, driedWhiteCornTable);
            this.addCategoryValue("CornType", _C_Variable);
        }
        return netWeight.subtract(_A_Variable.add(_B_Variable));
    }
}

