/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.farming.engine;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MProduct;
import org.compiere.util.Env;
import org.erpya.lve.farming.util.FAPVenezuelaLocationUtil;
import org.farming.engine.CategoryEngine;

public class Rice_ConditionedWeight
extends CategoryEngine {
    private final BigDecimal CONSTANT_88 = new BigDecimal(88);
    private final BigDecimal CONSTANT_12 = new BigDecimal(12);
    private final BigDecimal CONSTANT_17 = new BigDecimal(17);
    private final BigDecimal CONSTANT_4 = new BigDecimal(4);
    private final BigDecimal CONSTANT_1_5 = new BigDecimal(1.5);
    private final BigDecimal CONSTANT_8_5 = new BigDecimal(8.5);
    private final BigDecimal CONSTANT_14 = new BigDecimal(14);
    private final String CONSTANT_A = "A";
    private final String CONSTANT_B = "B";

    public BigDecimal calculate(Properties context, int bPartnerId, int productId, Timestamp date, BigDecimal netWeight, Map<String, Object> parameters, String transactionName) {
        BigDecimal humidity;
        MProduct product = MProduct.get((Properties)context, (int)productId);
        int precision = product.getUOMPrecision();
        BigDecimal humidityCalculated = humidity = Optional.ofNullable((BigDecimal)parameters.get("Humidity")).orElse(Env.ZERO);
        BigDecimal impurity = Optional.ofNullable((BigDecimal)parameters.get("Scrap")).orElse(Env.ZERO);
        netWeight = Optional.ofNullable(netWeight).orElse(Env.ZERO);
        BigDecimal grainsWithGypsumBellyBlank = Env.ZERO;
        BigDecimal totalDamagedGrains = Optional.ofNullable((BigDecimal)parameters.get("TotalDamagedGrains")).orElse(Env.ZERO);
        BigDecimal redGrains = Optional.ofNullable((BigDecimal)parameters.get("RedGrains")).orElse(Env.ZERO);
        BigDecimal greenGrains = Optional.ofNullable((BigDecimal)parameters.get("GreenGrains")).orElse(Env.ZERO);
        BigDecimal grainsWithoutShell = Optional.ofNullable((BigDecimal)parameters.get("Grains Without Shell")).orElse(Env.ZERO);
        BigDecimal grainsWithGypsum = Optional.ofNullable((BigDecimal)parameters.get("GrainsWithGypsum")).orElse(Env.ZERO);
        BigDecimal grainsBellyBlank = Optional.ofNullable((BigDecimal)parameters.get("GrainsBellyBlank")).orElse(Env.ZERO);
        BigDecimal stainedGrains = Optional.ofNullable((BigDecimal)parameters.get("StainedGrains")).orElse(Env.ZERO);
        BigDecimal damagedGrains = Optional.ofNullable((BigDecimal)parameters.get("DamagedGrains")).orElse(Env.ZERO);
        BigDecimal blackEndGrains = Optional.ofNullable((BigDecimal)parameters.get("BlackEndGrains")).orElse(Env.ZERO);
        grainsWithGypsumBellyBlank = grainsWithGypsum.add(grainsBellyBlank);
        String _C_Variable = "A";
        humidityCalculated = humidity.compareTo(this.CONSTANT_12) < 0 ? this.CONSTANT_12 : humidity;
        BigDecimal _A_Variable = netWeight.multiply(humidityCalculated.subtract(this.CONSTANT_12).divide(this.CONSTANT_88, MathContext.DECIMAL128)).setScale(precision, 6);
        BigDecimal _B_Variable = netWeight.subtract(_A_Variable).multiply(impurity.divide(Env.ONEHUNDRED, MathContext.DECIMAL128)).setScale(precision, 6);
        if (grainsWithGypsumBellyBlank.compareTo(this.CONSTANT_17) > 0) {
            _C_Variable = "B";
        }
        if (totalDamagedGrains.compareTo(this.CONSTANT_4) > 0) {
            _C_Variable = "B";
        }
        if (redGrains.compareTo(this.CONSTANT_1_5) > 0) {
            _C_Variable = "B";
        }
        if (greenGrains.compareTo(this.CONSTANT_8_5) > 0) {
            _C_Variable = "B";
        }
        if (grainsWithoutShell.compareTo(this.CONSTANT_1_5) > 0) {
            _C_Variable = "B";
        }
        HashMap<String, BigDecimal> riceParameters = new HashMap<String, BigDecimal>();
        riceParameters.put("StainedGrains", stainedGrains);
        riceParameters.put("DamagedGrains", damagedGrains);
        riceParameters.put("BlackEndGrains", blackEndGrains);
        riceParameters.put("GrainsWithGypsum", grainsWithGypsum);
        riceParameters.put("GrainsBellyBlank", grainsBellyBlank);
        riceParameters.put("GrainsWithGypsumBellyBlank", grainsWithGypsumBellyBlank);
        riceParameters.put("RedGrains", redGrains);
        riceParameters.put("GreenGrains", greenGrains);
        riceParameters.put("Grains Without Shell", grainsWithoutShell);
        String _D_Variable = FAPVenezuelaLocationUtil.getRiceType(riceParameters);
        this.addCategoryValue("HumidityDiscount", _A_Variable);
        this.addCategoryValue("ScrapDiscount", _B_Variable);
        if (humidity.compareTo(this.CONSTANT_14) >= 0) {
            this.addCategoryValue("ConditionType", "HUMEDO");
            this.addCategoryValue("RiceType", _C_Variable);
        } else {
            this.addCategoryValue("ConditionType", "SECO");
            this.addCategoryValue("RiceType", _D_Variable);
        }
        return netWeight.subtract(_A_Variable).subtract(_B_Variable);
    }
}

