/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.farming.engine;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MProduct;
import org.compiere.util.Env;
import org.farming.engine.CategoryEngine;

public class Corn_COVENIN_1935_2017_v1
extends CategoryEngine {
    private static final BigDecimal CONSTANT_88 = new BigDecimal(88);
    private static final BigDecimal HUMIDITY_24 = new BigDecimal(24);
    private static final BigDecimal HUMIDITY_12 = new BigDecimal(12);
    private static final BigDecimal SCRAP_5 = new BigDecimal(5);
    private static final BigDecimal SCRAP_2 = new BigDecimal(2);

    public BigDecimal calculate(Properties context, int bPartnerId, int productId, Timestamp date, BigDecimal netWeight, Map<String, Object> parameters, String transactionName) {
        MProduct product = MProduct.get((Properties)context, (int)productId);
        int precision = product.getUOMPrecision();
        BigDecimal humidity = Optional.ofNullable((BigDecimal)parameters.get("Humidity")).orElse(Env.ZERO);
        BigDecimal impurity = Optional.ofNullable((BigDecimal)parameters.get("Scrap")).orElse(Env.ZERO);
        netWeight = Optional.ofNullable(netWeight).orElse(Env.ZERO);
        BigDecimal totalDamagedGrains = Optional.ofNullable((BigDecimal)parameters.get("TotalDamagedGrains")).orElse(Env.ZERO);
        BigDecimal crackedGrains = Optional.ofNullable((BigDecimal)parameters.get("CrackedGrains")).orElse(Env.ZERO);
        BigDecimal heatDamagedGrains = Optional.ofNullable((BigDecimal)parameters.get("HeatDamagedGrains")).orElse(Env.ZERO);
        BigDecimal crystallizedGrains = Optional.ofNullable((BigDecimal)parameters.get("CrystallizedGrains")).orElse(Env.ZERO);
        BigDecimal reheatedGrains = Optional.ofNullable((BigDecimal)parameters.get("ReheatedGrains")).orElse(Env.ZERO);
        BigDecimal colorMix = Optional.ofNullable((BigDecimal)parameters.get("ColorMix")).orElse(Env.ZERO);
        BigDecimal objectionableSeeds = Optional.ofNullable((BigDecimal)parameters.get("ObjectionableSeeds")).orElse(Env.ZERO);
        BigDecimal aflatoxin = Optional.ofNullable((BigDecimal)parameters.get("Aflatoxin")).orElse(Env.ZERO);
        String conditionType = Optional.ofNullable((String)parameters.get("ConditionType")).orElse("");
        BigDecimal _A_Variable = Env.ZERO;
        BigDecimal _B_Variable = Env.ZERO;
        HashMap<Integer, Map<String, BigDecimal>> cornParameters = new HashMap<Integer, Map<String, BigDecimal>>();
        cornParameters.put(10, Collections.singletonMap("TotalDamagedGrains", totalDamagedGrains));
        cornParameters.put(20, Collections.singletonMap("CrackedGrains", crackedGrains));
        cornParameters.put(30, Collections.singletonMap("HeatDamagedGrains", heatDamagedGrains));
        cornParameters.put(40, Collections.singletonMap("CrystallizedGrains", crystallizedGrains));
        cornParameters.put(50, Collections.singletonMap("ReheatedGrains", reheatedGrains));
        cornParameters.put(60, Collections.singletonMap("ColorMix", colorMix));
        cornParameters.put(70, Collections.singletonMap("ObjectionableSeeds", objectionableSeeds));
        cornParameters.put(80, Collections.singletonMap("Aflatoxin", aflatoxin));
        if (conditionType.equals("HUMEDO")) {
            BigDecimal humidityCalculated = humidity.subtract(HUMIDITY_24);
            humidityCalculated = humidityCalculated.divide(CONSTANT_88, MathContext.DECIMAL128);
            _A_Variable = humidityCalculated = netWeight.multiply(humidityCalculated).setScale(precision, RoundingMode.HALF_UP);
            BigDecimal calculatedScrap = impurity.subtract(SCRAP_5).divide(Env.ONEHUNDRED, MathContext.DECIMAL128);
            _B_Variable = calculatedScrap = netWeight.multiply(calculatedScrap).setScale(precision, RoundingMode.HALF_UP);
        } else if (conditionType.equals("SECO")) {
            BigDecimal humidityCalculated = humidity.subtract(HUMIDITY_12);
            humidityCalculated = humidityCalculated.divide(CONSTANT_88, MathContext.DECIMAL128);
            _A_Variable = humidityCalculated = netWeight.multiply(humidityCalculated).setScale(precision, RoundingMode.HALF_UP);
            BigDecimal calculatedScrap = impurity.subtract(SCRAP_2).divide(Env.ONEHUNDRED, MathContext.DECIMAL128);
            _B_Variable = calculatedScrap = netWeight.multiply(calculatedScrap).setScale(precision, RoundingMode.HALF_UP);
        }
        this.addCategoryValue("HumidityDiscount", _A_Variable);
        this.addCategoryValue("ScrapDiscount", _B_Variable);
        return netWeight.subtract(_A_Variable.add(_B_Variable));
    }
}

