/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.farming.engine;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MProduct;
import org.compiere.util.Env;
import org.farming.engine.CategoryEngine;

public class Bean_ConditionedWeightAllAttributes
extends CategoryEngine {
    private final BigDecimal CONSTANT_0 = new BigDecimal(0);
    private final BigDecimal CONSTANT_2 = new BigDecimal(2);
    private final BigDecimal CONSTANT_5 = new BigDecimal(5);
    private final BigDecimal CONSTANT_8 = new BigDecimal(8);
    private final BigDecimal HUMIDITY_MINIMUM = new BigDecimal(9);
    private final BigDecimal HUMIDITY_MAXIMUM = new BigDecimal(10);
    private final BigDecimal CRACKED_MAXIMUM = new BigDecimal(2);
    private final BigDecimal DAMAGED_MAXIMUM = new BigDecimal(4);
    private final BigDecimal SCRAP_MINIMUM = new BigDecimal(1);
    private final String CONSTANT_A = "A";
    private final String CONSTANT_B = "B";
    private final String CONSTANT_C = "C";
    private final String CONSTANT_NC = "NC";

    public BigDecimal calculate(Properties context, int bPartnerId, int productId, Timestamp date, BigDecimal netWeight, Map<String, Object> parameters, String transactionName) {
        MProduct product = MProduct.get((Properties)context, (int)productId);
        int precision = product.getUOMPrecision();
        BigDecimal humidity = Optional.ofNullable((BigDecimal)parameters.get("Humidity")).orElse(Env.ZERO);
        BigDecimal cracked = Optional.ofNullable((BigDecimal)parameters.get("CrackedGrains")).orElse(Env.ZERO);
        BigDecimal scrap = Optional.ofNullable((BigDecimal)parameters.get("Scrap")).orElse(Env.ZERO);
        BigDecimal moldy = Optional.ofNullable((BigDecimal)parameters.get("Moldy")).orElse(Env.ZERO);
        BigDecimal germinated = Optional.ofNullable((BigDecimal)parameters.get("Germinated")).orElse(Env.ZERO);
        BigDecimal wrinkled = Optional.ofNullable((BigDecimal)parameters.get("Wrinkled")).orElse(Env.ZERO);
        BigDecimal damaged = Optional.ofNullable((BigDecimal)parameters.get("DamagedGrains")).orElse(Env.ZERO);
        damaged = damaged.add(moldy).add(germinated).add(wrinkled);
        netWeight = Optional.ofNullable(netWeight).orElse(Env.ZERO);
        String _Grain_Type = "NC";
        humidity = humidity.compareTo(this.HUMIDITY_MINIMUM) < 0 ? this.HUMIDITY_MINIMUM.subtract(humidity) : (humidity.compareTo(this.HUMIDITY_MAXIMUM) > 0 ? humidity.subtract(this.HUMIDITY_MAXIMUM) : Env.ZERO);
        cracked = cracked.compareTo(this.CRACKED_MAXIMUM) > 0 ? cracked.subtract(this.CRACKED_MAXIMUM) : this.CONSTANT_0;
        if (scrap.compareTo(this.SCRAP_MINIMUM) <= 0) {
            scrap = this.CONSTANT_0;
        }
        damaged = damaged.compareTo(this.DAMAGED_MAXIMUM) > 0 ? damaged.subtract(this.DAMAGED_MAXIMUM) : this.CONSTANT_0;
        BigDecimal _Humidity_Discount = netWeight.multiply(humidity.divide(Env.ONEHUNDRED, MathContext.DECIMAL128)).setScale(precision, 6);
        BigDecimal _Scrap_Discount = netWeight.multiply(scrap.divide(Env.ONEHUNDRED, MathContext.DECIMAL128)).setScale(precision, 6);
        BigDecimal _Cracked_Discount = netWeight.multiply(cracked.divide(Env.ONEHUNDRED, MathContext.DECIMAL128)).setScale(precision, 6);
        BigDecimal _Damaged_Discount = netWeight.multiply(damaged.divide(Env.ONEHUNDRED, MathContext.DECIMAL128)).setScale(precision, 6);
        if (damaged.compareTo(this.CONSTANT_0) >= 0 && damaged.compareTo(this.CONSTANT_2) <= 0) {
            _Grain_Type = "A";
        }
        if (damaged.compareTo(this.CONSTANT_2) > 0 && damaged.compareTo(this.CONSTANT_5) <= 0) {
            _Grain_Type = "B";
        }
        if (damaged.compareTo(this.CONSTANT_5) > 0 && damaged.compareTo(this.CONSTANT_8) <= 0) {
            _Grain_Type = "C";
        }
        if (damaged.compareTo(this.CONSTANT_8) > 0) {
            _Grain_Type = "NC";
        }
        this.addCategoryValue("ScrapDiscount", _Scrap_Discount);
        this.addCategoryValue("CrackedGrainsDiscount", _Cracked_Discount);
        this.addCategoryValue("GrainType", _Grain_Type);
        return netWeight.subtract(_Humidity_Discount).subtract(_Scrap_Discount).subtract(_Cracked_Discount).subtract(_Damaged_Discount);
    }
}

