/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.farming.engine;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MProduct;
import org.compiere.util.Env;
import org.farming.engine.CategoryEngine;

public class Bean_ConditionedWeight
extends CategoryEngine {
    private final BigDecimal CONSTANT_0 = new BigDecimal(0);
    private final BigDecimal CONSTANT_2 = new BigDecimal(2);
    private final BigDecimal CONSTANT_5 = new BigDecimal(5);
    private final BigDecimal CONSTANT_8 = new BigDecimal(8);
    private final String CONSTANT_A = "A";
    private final String CONSTANT_B = "B";
    private final String CONSTANT_C = "C";
    private final String CONSTANT_NC = "NC";

    public BigDecimal calculate(Properties context, int bPartnerId, int productId, Timestamp date, BigDecimal netWeight, Map<String, Object> parameters, String transactionName) {
        MProduct product = MProduct.get((Properties)context, (int)productId);
        int precision = product.getUOMPrecision();
        BigDecimal scrap = Optional.ofNullable((BigDecimal)parameters.get("Scrap")).orElse(Env.ZERO);
        BigDecimal crackedGrains = Optional.ofNullable((BigDecimal)parameters.get("CrackedGrains")).orElse(Env.ZERO);
        BigDecimal totalDamagedGrains = Optional.ofNullable((BigDecimal)parameters.get("TotalDamagedGrains")).orElse(Env.ZERO);
        netWeight = Optional.ofNullable(netWeight).orElse(Env.ZERO);
        String _C_Variable = "NC";
        BigDecimal _A_Variable = netWeight.multiply(scrap.divide(Env.ONEHUNDRED, MathContext.DECIMAL128)).setScale(precision, 6);
        BigDecimal _B_Variable = netWeight.subtract(_A_Variable).multiply(crackedGrains.divide(Env.ONEHUNDRED, MathContext.DECIMAL128)).setScale(precision, 6);
        if (totalDamagedGrains.compareTo(this.CONSTANT_0) >= 0 && totalDamagedGrains.compareTo(this.CONSTANT_2) <= 0) {
            _C_Variable = "A";
        }
        if (totalDamagedGrains.compareTo(this.CONSTANT_2) > 0 && totalDamagedGrains.compareTo(this.CONSTANT_5) <= 0) {
            _C_Variable = "B";
        }
        if (totalDamagedGrains.compareTo(this.CONSTANT_5) > 0 && totalDamagedGrains.compareTo(this.CONSTANT_8) <= 0) {
            _C_Variable = "C";
        }
        if (totalDamagedGrains.compareTo(this.CONSTANT_8) > 0) {
            _C_Variable = "NC";
        }
        this.addCategoryValue("ScrapDiscount", _A_Variable);
        this.addCategoryValue("CrackedGrainsDiscount", _B_Variable);
        this.addCategoryValue("GrainType", _C_Variable);
        return netWeight.subtract(_A_Variable).subtract(_B_Variable);
    }
}

